/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.potion_workshop;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.blocks.potion_workshop.PotionWorkshopBlockEntity;
import earth.terrarium.pastel.recipe.GatedStackPastelRecipe;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopReactingRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PotionWorkshopRecipe
extends GatedStackPastelRecipe<RecipeInput> {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("unlocks/blocks/potion_workshop");
    public static final int[] INGREDIENT_SLOTS = new int[]{2, 3, 4};
    protected final int craftingTime;
    protected final int color;
    protected final IngredientStack ingredient1;
    protected final IngredientStack ingredient2;
    protected final IngredientStack ingredient3;

    public PotionWorkshopRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, int craftingTime, int color, IngredientStack ingredient1, IngredientStack ingredient2, IngredientStack ingredient3) {
        super(group, secret, requiredAdvancementIdentifier);
        this.color = color;
        this.craftingTime = craftingTime;
        this.ingredient1 = ingredient1;
        this.ingredient2 = ingredient2;
        this.ingredient3 = ingredient3;
    }

    public List<IngredientStack> getOtherIngredients() {
        ArrayList<IngredientStack> ingredients = new ArrayList<IngredientStack>();
        ingredients.add(this.ingredient1);
        if (!this.ingredient2.isEmpty()) {
            ingredients.add(this.ingredient2);
            if (!this.ingredient3.isEmpty()) {
                ingredients.add(this.ingredient3);
            }
        }
        return ingredients;
    }

    protected void addIngredientStacks(NonNullList<IngredientStack> ingredients) {
        ingredients.add((Object)this.ingredient1);
        ingredients.add((Object)this.ingredient2);
        ingredients.add((Object)this.ingredient3);
    }

    public boolean matches(@NotNull RecipeInput inv, Level world) {
        if (inv.size() > 4 && inv.getItem(0).is((Item)PastelItems.MERMAIDS_GEM.get()) && this.isValidBaseIngredient(inv.getItem(1))) {
            if (this.usesReagents() ? !this.areStacksInReagentSlotsAllReagents(inv) : !this.areReagentSlotsEmpty(inv)) {
                return false;
            }
            return this.matchIngredientStacksExclusively(inv, this.getOtherIngredients(), INGREDIENT_SLOTS);
        }
        return false;
    }

    private boolean areStacksInReagentSlotsAllReagents(@NotNull RecipeInput inv) {
        for (int i : PotionWorkshopBlockEntity.REAGENT_SLOTS) {
            ItemStack itemStack = inv.getItem(i);
            if (itemStack.isEmpty() || PotionWorkshopReactingRecipe.isReagent(itemStack.getItem())) continue;
            return false;
        }
        return true;
    }

    private boolean areReagentSlotsEmpty(@NotNull RecipeInput inv) {
        for (int i : PotionWorkshopBlockEntity.REAGENT_SLOTS) {
            if (inv.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isValidBaseIngredient(ItemStack var1);

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getToastSymbol() {
        return ((Block)PastelBlocks.POTION_WORKSHOP.get()).asItem().getDefaultInstance();
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.ANVIL_CRUSHING_RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.ANVIL_CRUSHING;
    }

    public abstract boolean usesReagents();

    public abstract int getMinOutputCount(ItemStack var1);

    public int getColor() {
        return this.color;
    }

    @Override
    @Nullable
    public ResourceLocation typeAdvancementID() {
        return UNLOCK_IDENTIFIER;
    }

    public int getRequiredExperience() {
        return 0;
    }
}

