/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.spirit_instiller.dynamic;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.blocks.memory.MemoryBlockEntity;
import earth.terrarium.pastel.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import earth.terrarium.pastel.loot.modifiers.TreasureHunterModifier;
import earth.terrarium.pastel.recipe.InstanceRecipeInput;
import earth.terrarium.pastel.recipe.spirit_instiller.SpiritInstillerRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class MemoryToHeadRecipe
extends SpiritInstillerRecipe {
    public MemoryToHeadRecipe() {
        super("", false, Optional.of(PastelCommon.locate("unlocks/memory_to_head")), IngredientStack.ofItems(((Block)PastelBlocks.MEMORY.get()).asItem()), IngredientStack.ofItems((Item)PastelItems.VEGETAL.get(), 4), IngredientStack.ofItems((Item)PastelItems.QUITOXIC_POWDER.get(), 4), new ItemStack((ItemLike)Blocks.ZOMBIE_HEAD), 200, 1.0f, true);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.SPIRIT_INSTILLER_MEMORY_TO_HEAD;
    }

    @Override
    public boolean matches(InstanceRecipeInput input, Level world) {
        if (this.bowlMatches(input)) {
            return input.getItem(0).is(PastelBlocks.MEMORY.asItem());
        }
        return false;
    }

    @Override
    public ItemStack assemble(InstanceRecipeInput<SpiritInstillerBlockEntity> recipeInput, HolderLookup.Provider drm) {
        BlockPos pos;
        SpiritInstillerBlockEntity spiritInstillerBlockEntity = recipeInput.getInstance();
        ItemStack resultStack = ItemStack.EMPTY;
        ServerLevel world = (ServerLevel)spiritInstillerBlockEntity.getLevel();
        Optional<Entity> entity = MemoryBlockEntity.hatchEntity(world, pos = spiritInstillerBlockEntity.getBlockPos(), spiritInstillerBlockEntity.getItem(0));
        if (entity.isPresent()) {
            Optional<Item> proposed = TreasureHunterModifier.tryGetHead(entity.get());
            if (proposed.isPresent()) {
                resultStack = new ItemStack((ItemLike)proposed.get());
            }
            entity.get().discard();
        }
        this.spawnXPAndGrantAdvancements(resultStack, spiritInstillerBlockEntity, spiritInstillerBlockEntity.getUpgradeHolder(), (Level)world, pos);
        return resultStack;
    }

    @Override
    public boolean canCraftWithStacks(RecipeInput inventory, Level level) {
        ItemStack instillerStack = inventory.getItem(0);
        Optional<Entity> entity = MemoryBlockEntity.hatchEntity((ServerLevel)level, BlockPos.ZERO, instillerStack);
        return entity.filter(e -> TreasureHunterModifier.tryGetHead(e).isPresent()).isPresent();
    }
}

