/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.spirit_instiller.dynamic.spawner_manipulation;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.blocks.item_bowl.ItemBowlBlockEntity;
import earth.terrarium.pastel.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import earth.terrarium.pastel.recipe.InstanceRecipeInput;
import earth.terrarium.pastel.recipe.spirit_instiller.SpiritInstillerRecipe;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public abstract class SpawnerChangeRecipe
extends SpiritInstillerRecipe {
    public SpawnerChangeRecipe(IngredientStack ingredient, IngredientStack ingredient2, Optional<ResourceLocation> requiredAdvancementIdentifier) {
        super("spawner_manipulation", false, requiredAdvancementIdentifier, IngredientStack.ofItems(Items.SPAWNER), ingredient, ingredient2, Items.SPAWNER.getDefaultInstance(), 200, 0.0f, true);
    }

    public SpawnerChangeRecipe(IngredientStack ingredient) {
        super("spawner_manipulation", false, Optional.of(PastelAdvancements.SPAWNER_MANIPULATION), IngredientStack.ofItems(Items.SPAWNER), ingredient, IngredientStack.ofItems((Item)PastelItems.VEGETAL.get(), 4), Items.SPAWNER.getDefaultInstance(), 200, 0.0f, true);
    }

    @Override
    public ItemStack assemble(InstanceRecipeInput<SpiritInstillerBlockEntity> recipeInput, HolderLookup.Provider drm) {
        SpiritInstillerBlockEntity spiritInstillerBlockEntity = recipeInput.getInstance();
        ItemStack resultStack = ItemStack.EMPTY;
        Level world = spiritInstillerBlockEntity.getLevel();
        if (world == null) {
            return ItemStack.EMPTY;
        }
        BlockEntity leftBowlBlockEntity = world.getBlockEntity(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, false));
        BlockEntity rightBowlBlockEntity = world.getBlockEntity(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, true));
        if (leftBowlBlockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity leftBowl = (ItemBowlBlockEntity)leftBowlBlockEntity;
            if (rightBowlBlockEntity instanceof ItemBowlBlockEntity) {
                ItemBowlBlockEntity rightBowl = (ItemBowlBlockEntity)rightBowlBlockEntity;
                BlockPos pos = spiritInstillerBlockEntity.getBlockPos();
                ItemStack firstBowlStack = leftBowl.getItem(0);
                ItemStack secondBowlStack = rightBowl.getItem(0);
                ItemStack spawnerStack = spiritInstillerBlockEntity.getItem(0);
                CompoundTag spawnerNbt = ((CustomData)spawnerStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
                spawnerNbt = this.getSpawnerResultNbt(spawnerNbt, firstBowlStack, secondBowlStack);
                resultStack = spawnerStack.copy();
                resultStack.setCount(1);
                BlockEntity.addEntityType((CompoundTag)spawnerNbt, (BlockEntityType)BlockEntityType.MOB_SPAWNER);
                resultStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)spawnerNbt));
                this.spawnXPAndGrantAdvancements(resultStack, spiritInstillerBlockEntity, spiritInstillerBlockEntity.getUpgradeHolder(), world, pos);
            }
        }
        return resultStack;
    }

    @Override
    public boolean canCraftWithStacks(RecipeInput inventory, Level level) {
        CustomData blockEntityComponent = (CustomData)inventory.getItem(0).getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        return this.canCraftWithBlockEntityTag(blockEntityComponent, inventory.getItem(1), inventory.getItem(2));
    }

    public abstract boolean canCraftWithBlockEntityTag(CustomData var1, ItemStack var2, ItemStack var3);

    public abstract CompoundTag getSpawnerResultNbt(CompoundTag var1, ItemStack var2, ItemStack var3);

    public abstract Component getOutputLoreText();
}

