/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.entity.InkProjectileEntity;
import earth.terrarium.pastel.spells.MoonstoneStrike;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PastelDamageTypes {
    public static final ResourceKey<DamageType> BRISTLE_SPROUTS = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("bristle_sprouts"));
    public static final ResourceKey<DamageType> DEADLY_POISON = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("deadly_poison"));
    public static final ResourceKey<DamageType> DECAY = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("decay"));
    public static final ResourceKey<DamageType> DIKE_GATE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("dike_gate"));
    public static final ResourceKey<DamageType> DRAGONROT = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("dragonrot"));
    public static final ResourceKey<DamageType> EVISCERATION = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("evisceration"));
    public static final ResourceKey<DamageType> FLOATBLOCK = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("floatblock"));
    public static final ResourceKey<DamageType> IMPALING = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("impaling"));
    public static final ResourceKey<DamageType> INCANDESCENCE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("incandescence"));
    public static final ResourceKey<DamageType> INK_PROJECTILE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("ink_projectile"));
    public static final ResourceKey<DamageType> IRRADIANCE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("irradiance"));
    public static final ResourceKey<DamageType> KINDLING_COUGH = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("kindling_cough"));
    public static final ResourceKey<DamageType> MIDNIGHT_SOLUTION = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("midnight_solution"));
    public static final ResourceKey<DamageType> MOONSTONE_STRIKE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("moonstone_strike"));
    public static final ResourceKey<DamageType> PRIMORDIAL_FIRE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("primordial_fire"));
    public static final ResourceKey<DamageType> RIPPING = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("ripping"));
    public static final ResourceKey<DamageType> SET_HEALTH = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("set_health"));
    public static final ResourceKey<DamageType> SHOOTING_STAR = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("shooting_star"));
    public static final ResourceKey<DamageType> SLEEP = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("sleep"));
    public static final ResourceKey<DamageType> SNAPPING_IVY = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PastelCommon.locate("snapping_ivy"));

    public static DamageSource sleep(Level world, @Nullable LivingEntity attacker) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(SLEEP), (Entity)attacker);
    }

    public static DamageSource ripping(Level world) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(RIPPING));
    }

    public static DamageSource dragonrot(Level world) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(DRAGONROT));
    }

    public static DamageSource inkProjectile(InkProjectileEntity projectile, @Nullable Entity attacker) {
        return new DamageSource((Holder)projectile.damageSources().damageTypes.getHolderOrThrow(INK_PROJECTILE), (Entity)projectile, attacker);
    }

    public static DamageSource moonstoneStrike(Level world, @Nullable MoonstoneStrike moonstoneStrike) {
        return PastelDamageTypes.moonstoneStrike(world, moonstoneStrike != null ? moonstoneStrike.getCausingEntity() : null);
    }

    public static DamageSource moonstoneStrike(Level world, @Nullable LivingEntity attacker) {
        return new MoonstoneStrikeDamageSource(world, attacker);
    }

    public static DamageSource irradiance(Level world, @Nullable LivingEntity attacker) {
        return new IrradianceDamageSource(world, attacker);
    }

    public static DamageSource impaling(Level world, Entity weapon, @Nullable Entity attacker) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(IMPALING), weapon, attacker);
    }

    public static DamageSource impaling(Level world, @Nullable Entity attacker) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(IMPALING), attacker);
    }

    public static DamageSource evisceration(Level world, @Nullable Entity attacker) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(EVISCERATION), attacker);
    }

    public static DamageSource setHealth(Level world, @Nullable LivingEntity attacker) {
        return new SetHealthDamageSource(world, attacker);
    }

    public static DamageSource floatblock(Level world) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(FLOATBLOCK));
    }

    public static DamageSource shootingStar(Level world) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(SHOOTING_STAR));
    }

    public static DamageSource incandescence(Level world) {
        return PastelDamageTypes.incandescence(world, null);
    }

    public static DamageSource incandescence(Level world, @Nullable Entity attacker) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(INCANDESCENCE), attacker);
    }

    public static DamageSource midnightSolution(Level world) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(MIDNIGHT_SOLUTION));
    }

    public static DamageSource decay(Level world) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(DECAY));
    }

    public static DamageSource deadlyPoison(Level world) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(DEADLY_POISON));
    }

    public static DamageSource dike(Level world) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(DIKE_GATE));
    }

    public static DamageSource bristeSprouts(Level world) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(BRISTLE_SPROUTS));
    }

    public static DamageSource kindlingCough(Level world, @Nullable LivingEntity attacker) {
        return new KindlingCoughDamageSource(world, attacker);
    }

    public static DamageSource snappingIvy(Level world) {
        return new DamageSource((Holder)world.damageSources().damageTypes.getHolderOrThrow(SNAPPING_IVY));
    }

    public static DamageSource primordialFire(Level world) {
        return new PrimordialFireDamageSource(world, null);
    }

    public static DamageSource primordialFire(Level world, @Nullable LivingEntity attacker) {
        return new PrimordialFireDamageSource(world, attacker);
    }

    public static class MoonstoneStrikeDamageSource
    extends DamageSource {
        public MoonstoneStrikeDamageSource(Level world, LivingEntity attacker) {
            super((Holder)world.damageSources().damageTypes.getHolderOrThrow(MOONSTONE_STRIKE), (Entity)attacker);
        }

        public MoonstoneStrikeDamageSource(MoonstoneStrike moonstoneStrike) {
            super(moonstoneStrike.getDamageSource().typeHolder(), (Entity)moonstoneStrike.getCausingEntity());
        }
    }

    public static class IrradianceDamageSource
    extends DamageSource {
        public IrradianceDamageSource(Level world, @Nullable LivingEntity attacker) {
            super((Holder)world.damageSources().damageTypes.getHolderOrThrow(IRRADIANCE), (Entity)attacker);
        }
    }

    public static class SetHealthDamageSource
    extends DamageSource {
        public SetHealthDamageSource(Level world, @Nullable LivingEntity attacker) {
            super((Holder)world.damageSources().damageTypes.getHolderOrThrow(SET_HEALTH), (Entity)attacker);
        }
    }

    public static class KindlingCoughDamageSource
    extends DamageSource {
        public KindlingCoughDamageSource(Level world, @Nullable LivingEntity attacker) {
            super((Holder)world.damageSources().damageTypes.getHolderOrThrow(KINDLING_COUGH), (Entity)attacker);
        }
    }

    public static class PrimordialFireDamageSource
    extends DamageSource {
        public PrimordialFireDamageSource(Level world, @Nullable LivingEntity attacker) {
            super((Holder)world.damageSources().damageTypes.getHolderOrThrow(PRIMORDIAL_FIRE), (Entity)attacker);
        }
    }
}

