/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.InkPoweredStatusEffectInstance;
import earth.terrarium.pastel.mixin.accessors.StatusEffectInstanceAccessor;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import earth.terrarium.pastel.status_effects.AscensionStatusEffect;
import earth.terrarium.pastel.status_effects.DeadlyPoisonStatusEffect;
import earth.terrarium.pastel.status_effects.DivinityStatusEffect;
import earth.terrarium.pastel.status_effects.EffectProlongingStatusEffect;
import earth.terrarium.pastel.status_effects.FrenzyStatusEffect;
import earth.terrarium.pastel.status_effects.GravityStatusEffect;
import earth.terrarium.pastel.status_effects.ImmunityStatusEffect;
import earth.terrarium.pastel.status_effects.LifeDrainStatusEffect;
import earth.terrarium.pastel.status_effects.NoopStatusEffect;
import earth.terrarium.pastel.status_effects.NourishingStatusEffect;
import earth.terrarium.pastel.status_effects.ScarredStatusEffect;
import earth.terrarium.pastel.status_effects.SleepStatusEffect;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PastelMobEffects {
    public static final int ETERNAL_SLUMBER_COLOR = 12804078;
    public static boolean effectsAreGettingStacked = false;
    private static final DeferredRegister<MobEffect> REGISTER = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"pastel");
    public static final Holder<MobEffect> IMMUNITY = REGISTER.register("immunity", () -> new ImmunityStatusEffect(MobEffectCategory.NEUTRAL, 4964053).addAttributeModifier(PastelEntityAttributes.MENTAL_PRESENCE, PastelCommon.locate("effect.immunity"), 1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> NOURISHING = REGISTER.register("nourishing", () -> new NourishingStatusEffect(MobEffectCategory.BENEFICIAL, 2303224));
    public static final Holder<MobEffect> ANOTHER_ROLL = REGISTER.register("another_roll", () -> new NoopStatusEffect(MobEffectCategory.BENEFICIAL, 10604032));
    public static final Holder<MobEffect> SCARRED = REGISTER.register("scarred", () -> new ScarredStatusEffect(MobEffectCategory.HARMFUL, 5971229));
    public static final float VULNERABILITY_ADDITIONAL_DAMAGE_PERCENT_PER_LEVEL = 0.25f;
    public static final Holder<MobEffect> VULNERABILITY = REGISTER.register("vulnerability", () -> new NoopStatusEffect(MobEffectCategory.HARMFUL, 0x353535));
    public static final Holder<MobEffect> LIGHTWEIGHT = REGISTER.register("lightweight", () -> new GravityStatusEffect(MobEffectCategory.NEUTRAL, 56804, 0.02f));
    public static final Holder<MobEffect> DENSITY = REGISTER.register("density", () -> new GravityStatusEffect(MobEffectCategory.HARMFUL, 6756901, -0.02f));
    public static final Holder<MobEffect> SWIFTNESS = REGISTER.register("swiftness", () -> new NoopStatusEffect(MobEffectCategory.BENEFICIAL, 16770406).addAttributeModifier(Attributes.ATTACK_SPEED, PastelCommon.locate("effect.swiftness"), 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> STIFFNESS = REGISTER.register("stiffness", () -> new NoopStatusEffect(MobEffectCategory.HARMFUL, 8287561).addAttributeModifier(Attributes.ATTACK_SPEED, PastelCommon.locate("effect.stiffness"), -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> MAGIC_ANNULATION = REGISTER.register("magic_annulation", () -> new NoopStatusEffect(MobEffectCategory.BENEFICIAL, 7999618).addAttributeModifier(AdditionalEntityAttributes.MAGIC_PROTECTION, PastelCommon.locate("effect.magic_annulation"), 1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> DEADLY_POISON = REGISTER.register("deadly_poison", () -> new DeadlyPoisonStatusEffect(MobEffectCategory.HARMFUL, 5149489));
    public static final Holder<MobEffect> TOUGHNESS = REGISTER.register("toughness", () -> new NoopStatusEffect(MobEffectCategory.BENEFICIAL, 2669536).addAttributeModifier(Attributes.ARMOR_TOUGHNESS, PastelCommon.locate("effect.toughness"), 1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> EFFECT_PROLONGING = REGISTER.register("effect_prolonging", () -> new EffectProlongingStatusEffect(MobEffectCategory.BENEFICIAL, 12616149));
    public static final Holder<MobEffect> LIFE_DRAIN = REGISTER.register("life_drain", () -> new LifeDrainStatusEffect(MobEffectCategory.HARMFUL, 0x222222).addAttributeModifier(Attributes.MAX_HEALTH, LifeDrainStatusEffect.ATTRIBUTE_ID, -1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> ASCENSION = REGISTER.register("ascension", () -> new AscensionStatusEffect(MobEffectCategory.BENEFICIAL, 14678524));
    public static final Holder<MobEffect> DIVINITY = REGISTER.register("divinity", () -> new DivinityStatusEffect(MobEffectCategory.BENEFICIAL, 14678524).addAttributeModifier(Attributes.ATTACK_SPEED, PastelCommon.locate("effect.divinity.attack_speed"), 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(Attributes.MOVEMENT_SPEED, PastelCommon.locate("effect.divinity.movement_speed"), 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(Attributes.ATTACK_DAMAGE, PastelCommon.locate("effect.divinity.attack_damage"), 2.0, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(Attributes.ATTACK_KNOCKBACK, PastelCommon.locate("effect.divinity.attack_knockback"), 1.0, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(Attributes.ARMOR, PastelCommon.locate("effect.divinity.armor"), 2.0, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(Attributes.ARMOR_TOUGHNESS, PastelCommon.locate("effect.divinity.armor_toughness"), 2.0, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(Attributes.KNOCKBACK_RESISTANCE, PastelCommon.locate("effect.divinity.knockback_resistance"), 1.0, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(PastelEntityAttributes.MENTAL_PRESENCE, PastelCommon.locate("effect.divinity.mental_presence"), 0.25, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> FRENZY = REGISTER.register("frenzy", () -> new FrenzyStatusEffect(MobEffectCategory.NEUTRAL, 0x990000).addAttributeModifier(Attributes.ATTACK_SPEED, PastelCommon.locate("effect.frenzy.attack_speed"), 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(Attributes.ATTACK_DAMAGE, PastelCommon.locate("effect.frenzy.attack_damage"), 0.5, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(Attributes.MOVEMENT_SPEED, PastelCommon.locate("effect.frenzy.movement_speed"), 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(Attributes.KNOCKBACK_RESISTANCE, PastelCommon.locate("effect.frenzy.knockback_resistance"), 0.25, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(PastelEntityAttributes.MENTAL_PRESENCE, PastelCommon.locate("effect.frenzy.mental_presence"), 5.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> LAVA_GLIDING = REGISTER.register("lava_gliding", () -> new NoopStatusEffect(MobEffectCategory.BENEFICIAL, 12856846).addAttributeModifier(AdditionalEntityAttributes.LAVA_SPEED, PastelCommon.locate("effect.lava_gliding.lava_speed"), 0.1, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(AdditionalEntityAttributes.LAVA_VISIBILITY, PastelCommon.locate("effect.lava_gliding.lava_visibility"), 8.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> CALMING = REGISTER.register("calming", () -> new SleepStatusEffect(MobEffectCategory.BENEFICIAL, 6281139, true).addAttributeModifier(AdditionalEntityAttributes.MOB_DETECTION_RANGE, PastelCommon.locate("effect.calming.mob_detection_range"), -0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(PastelEntityAttributes.MENTAL_PRESENCE, PastelCommon.locate("effect.calming.mental_presence"), -0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> SOMNOLENCE = REGISTER.register("somnolence", () -> new SleepStatusEffect(MobEffectCategory.NEUTRAL, 11434988, true).addAttributeModifier(PastelEntityAttributes.MENTAL_PRESENCE, PastelCommon.locate("effect.somnolence"), -0.5, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> ETERNAL_SLUMBER = REGISTER.register("eternal_slumber", () -> new SleepStatusEffect(MobEffectCategory.HARMFUL, 12804078, false).addAttributeModifier(PastelEntityAttributes.MENTAL_PRESENCE, PastelCommon.locate("effect.eternal_slumber"), -2.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> FATAL_SLUMBER = REGISTER.register("fatal_slumber", () -> new SleepStatusEffect(MobEffectCategory.HARMFUL, 8468162, false).addAttributeModifier(PastelEntityAttributes.MENTAL_PRESENCE, PastelCommon.locate("effect.fatal_slumber"), -2.0, AttributeModifier.Operation.ADD_VALUE));
    public static final float PROJECTILE_REBOUND_CHANCE_PER_LEVEL = 0.2f;
    public static final Holder<MobEffect> PROJECTILE_REBOUND = REGISTER.register("projectile_rebound", () -> new NoopStatusEffect(MobEffectCategory.BENEFICIAL, 7857887));

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
    }

    public static boolean isStrongSleepEffect(MobEffectInstance instance) {
        return instance.getEffect() == ETERNAL_SLUMBER || instance.getEffect() == FATAL_SLUMBER;
    }

    public static boolean isStrongSleepEffect(InkPoweredStatusEffectInstance instance) {
        return PastelMobEffects.isStrongSleepEffect(instance.getStatusEffectInstance());
    }

    public static void cutDuration(LivingEntity instance, MobEffectInstance effect) {
        int duration = effect.getDuration();
        ((StatusEffectInstanceAccessor)effect).setDuration(Math.max(duration - 1200, (int)((double)duration * 0.4)));
        Level level = instance.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getChunkSource().broadcastAndSend((Entity)instance, (Packet)new ClientboundUpdateMobEffectPacket(instance.getId(), effect, false));
        }
    }

    public static float vulnerabilityMod(MobEffectInstance effect) {
        return 1.0f + 0.25f * (float)(effect.getAmplifier() + 1);
    }

    public static class Cures {
        public static final EffectCure SEDATIVES = EffectCure.get((String)"sedatives");
        public static final EffectCure BLOOD_ORCHID = EffectCure.get((String)"blood_orchid");
        public static final EffectCure INCURABLE = EffectCure.get((String)"incurable");
    }
}

