/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.data.DatagenProxy;
import earth.terrarium.pastel.registries.PastelBiomeTags;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class PastelPlacedFeatures {
    public static ResourceKey<PlacedFeature> of(String id) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate(id));
    }

    private static HolderSet<Biome> tag(DatagenProxy.BootstrapContext<BiomeModifier> context, TagKey<Biome> tag) {
        return context.registerable().lookup(Registries.BIOME).get(tag).map(Function.identity()).orElse(HolderSet.empty());
    }

    private static void addFeature(DatagenProxy.BootstrapContext<BiomeModifier> context, TagKey<Biome> tag, GenerationStep.Decoration step, ResourceKey<PlacedFeature> placedFeature) {
        HolderGetter biomes = context.registerable().lookup(Registries.BIOME);
        biomes.get(tag).ifPresent(set -> PastelPlacedFeatures.addFeature(context, (HolderSet<Biome>)set, step, placedFeature));
    }

    private static void addFeature(DatagenProxy.BootstrapContext<BiomeModifier> context, HolderSet<Biome> biomeSet, GenerationStep.Decoration step, ResourceKey<PlacedFeature> placedFeature) {
        HolderGetter placedFeatures = context.registerable().lookup(Registries.PLACED_FEATURE);
        context.registerable().register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)placedFeature.location()), (Object)new BiomeModifiers.AddFeaturesBiomeModifier(biomeSet, (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(placedFeature)}), step));
    }

    public static void addBiomeModifications(DatagenProxy.BootstrapContext<BiomeModifier> context) {
        PastelPlacedFeatures.addFeature(context, (TagKey<Biome>)Tags.Biomes.IS_OVERWORLD, GenerationStep.Decoration.UNDERGROUND_STRUCTURES, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("citrine_geode")));
        PastelPlacedFeatures.addFeature(context, (TagKey<Biome>)Tags.Biomes.IS_OVERWORLD, GenerationStep.Decoration.UNDERGROUND_STRUCTURES, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("topaz_geode")));
        PastelPlacedFeatures.addFeature(context, (TagKey<Biome>)Tags.Biomes.IS_OVERWORLD, GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("shimmerstone_ore")));
        PastelPlacedFeatures.addFeature(context, (TagKey<Biome>)Tags.Biomes.IS_OVERWORLD, GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("azurite_ore")));
        PastelPlacedFeatures.addFeature(context, (TagKey<Biome>)Tags.Biomes.IS_NETHER, GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("stratine_ore")));
        PastelPlacedFeatures.addFeature(context, (TagKey<Biome>)Tags.Biomes.IS_END, GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("paltaeria_ore")));
        PastelPlacedFeatures.addFeature(context, PastelBiomeTags.COLORED_TREES_GENERATING_IN, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("colored_tree_patch")));
        PastelPlacedFeatures.addFeature(context, PastelBiomeTags.MERMAIDS_BRUSHES_GENERATING_IN, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("mermaids_brushes")));
        PastelPlacedFeatures.addFeature(context, PastelBiomeTags.CLOVER_GENERATING_IN, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("clover_patch")));
        PastelPlacedFeatures.addFeature(context, PastelBiomeTags.QUITOXIC_REEDS_GENERATING_IN, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("quitoxic_reeds")));
        PastelPlacedFeatures.addFeature(context, PastelBiomeTags.DRAGONBONE_FOSSILS_GENERATING_IN, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("dragon_fossil_overworld_buried")));
        PastelPlacedFeatures.addFeature(context, PastelBiomeTags.DRAGONBONE_FOSSILS_GENERATING_IN, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PastelCommon.locate("dragon_fossil_overworld_exposed")));
    }
}

