/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.api.item.PresentUnpackBehavior;
import earth.terrarium.pastel.blocks.amalgam.IncandescentAmalgamBlock;
import earth.terrarium.pastel.blocks.memory.MemoryBlockEntity;
import earth.terrarium.pastel.blocks.present.PresentBlock;
import earth.terrarium.pastel.mixin.accessors.GoatHornItemAccessor;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class PastelPresentUnpackBehaviors {
    public static void register() {
        PresentBlock.registerBehavior(PastelItems.PIPE_BOMB.getId(), (stack, presentBlockEntity, world, pos, random) -> {
            stack.set(PastelDataComponentTypes.TIMESTAMP, (Object)(world.getGameTime() - 70L));
            stack.set(DataComponents.PROFILE, (Object)presentBlockEntity.getOwner());
            world.playSound(null, pos, PastelSounds.INCANDESCENT_ARM, SoundSource.BLOCKS, 2.0f, 0.9f);
            return stack;
        });
        PresentBlock.registerBehavior(PastelItems.STORM_STONE.getId(), (stack, presentBlockEntity, world, pos, random) -> {
            if (world.canSeeSky(pos)) {
                LightningBolt lightningEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)world);
                if (lightningEntity != null) {
                    lightningEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                    world.addFreshEntity((Entity)lightningEntity);
                }
                return ItemStack.EMPTY;
            }
            return stack;
        });
        PresentBlock.registerBehavior(PastelBlocks.INCANDESCENT_AMALGAM.getId(), (stack, presentBlockEntity, world, pos, random) -> {
            IncandescentAmalgamBlock.explode((Level)world, pos, (Entity)presentBlockEntity.getOwnerIfOnline(), stack);
            return ItemStack.EMPTY;
        });
        PresentBlock.registerBehavior(BuiltInRegistries.ITEM.getKey((Object)Items.FIREWORK_ROCKET), (stack, presentBlockEntity, world, pos, random) -> {
            Vec3 centerPos = Vec3.atLowerCornerOf((Vec3i)pos);
            for (int i = 0; i < stack.getCount(); ++i) {
                FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity((Level)world, (Entity)presentBlockEntity.getOwnerIfOnline(), centerPos.x + 0.35 + (double)random.nextFloat() * 0.3, centerPos.y + 0.35 + (double)random.nextFloat() * 0.3, centerPos.z + 0.35 + (double)random.nextFloat() * 0.3, stack);
                world.addFreshEntity((Entity)fireworkRocketEntity);
            }
            return ItemStack.EMPTY;
        });
        PresentBlock.registerBehavior(BuiltInRegistries.ITEM.getKey((Object)Items.GOAT_HORN), (stack, presentBlockEntity, world, pos, random) -> {
            Optional<Holder<Instrument>> optional = ((GoatHornItemAccessor)stack.getItem()).invokeGetInstrument(stack);
            if (optional.isPresent()) {
                Instrument instrument = (Instrument)optional.get().value();
                SoundEvent soundEvent = (SoundEvent)instrument.soundEvent().value();
                world.playSound(null, pos, soundEvent, SoundSource.RECORDS, instrument.range() / 16.0f, 1.0f);
            }
            return stack;
        });
        PresentBlock.registerBehavior(BuiltInRegistries.ITEM.getKey((Object)Items.BELL), (stack, presentBlockEntity, world, pos, random) -> {
            world.playSound(null, pos, SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 2.0f, 1.0f);
            return stack;
        });
        PresentBlock.registerBehavior(BuiltInRegistries.ITEM.getKey((Object)Items.TNT), (stack, presentBlockEntity, world, pos, random) -> {
            if (stack.getCount() > 0) {
                PrimedTnt tntEntity = null;
                for (int i = 0; i < stack.getCount(); ++i) {
                    tntEntity = new PrimedTnt((Level)world, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, (LivingEntity)presentBlockEntity.getOwnerIfOnline());
                    world.addFreshEntity((Entity)tntEntity);
                }
                world.playSound(null, tntEntity.getX(), tntEntity.getY(), tntEntity.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.gameEvent(null, (Holder)GameEvent.PRIME_FUSE, pos);
            }
            return ItemStack.EMPTY;
        });
        PresentUnpackBehavior POTION_BEHAVIOR = (stack, presentBlockEntity, world, pos, random) -> {
            Vec3 centerPos = Vec3.atCenterOf((Vec3i)pos);
            for (int i = 0; i < stack.getCount(); ++i) {
                ThrownPotion entity = new ThrownPotion((Level)world, centerPos.x(), centerPos.y(), centerPos.z());
                entity.setItem(stack);
                world.addFreshEntity((Entity)entity);
            }
            PotionContents component = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            world.levelEvent(2002, pos, component.getColor());
            return ItemStack.EMPTY;
        };
        PresentBlock.registerBehavior(BuiltInRegistries.ITEM.getKey((Object)Items.SPLASH_POTION), POTION_BEHAVIOR);
        PresentBlock.registerBehavior(BuiltInRegistries.ITEM.getKey((Object)Items.LINGERING_POTION), POTION_BEHAVIOR);
        PresentBlock.registerBehavior(BuiltInRegistries.ITEM.getKey((Object)Items.EXPERIENCE_BOTTLE), (stack, presentBlockEntity, world, pos, random) -> {
            int totalXP = 0;
            for (int i = 0; i < stack.getCount(); ++i) {
                totalXP += 3 + random.nextInt(5) + random.nextInt(5);
            }
            world.levelEvent(2002, pos, new PotionContents(Potions.WATER).getColor());
            ExperienceOrb.award((ServerLevel)world, (Vec3)Vec3.atCenterOf((Vec3i)pos), (int)totalXP);
            return ItemStack.EMPTY;
        });
        PresentBlock.registerBehavior(BuiltInRegistries.ITEM.getKey((Object)Items.EGG), (stack, presentBlockEntity, world, pos, random) -> {
            int chickenCount = stack.getCount();
            for (int i = 0; i < chickenCount; ++i) {
                Chicken chickenEntity = (Chicken)EntityType.CHICKEN.create((Level)world);
                if (chickenEntity == null) continue;
                chickenEntity.setAge(-24000);
                chickenEntity.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0f, 0.0f);
                world.addFreshEntity((Entity)chickenEntity);
            }
            return ItemStack.EMPTY;
        });
        PresentBlock.registerBehavior(PastelBlocks.MEMORY.getId(), (stack, presentBlockEntity, world, pos, random) -> {
            MemoryBlockEntity.manifest(world, pos, stack, presentBlockEntity.getOpenerUUID());
            return ItemStack.EMPTY;
        });
    }
}

