/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class PastelTooltips {
    public static void register(ItemTooltipEvent event) {
        Item.TooltipContext context = event.getContext();
        List lines = event.getToolTip();
        ItemStack stack = event.getItemStack();
        DataComponentMap components = stack.getComponents();
        if (!components.isEmpty()) {
            if (stack.is(Blocks.SCULK_SHRIEKER.asItem())) {
                PastelTooltips.addSculkShriekerTooltips(lines, components);
            } else if (stack.is(ItemTags.SIGNS)) {
                PastelTooltips.addSignTooltips(lines, components);
            } else if (stack.is(Items.SPAWNER)) {
                PastelTooltips.addSpawnerTooltips(lines, components);
            }
        }
    }

    private static void addSculkShriekerTooltips(List<Component> lines, DataComponentMap components) {
        BlockItemStateProperties stateComponent = (BlockItemStateProperties)components.get(DataComponents.BLOCK_STATE);
        if (stateComponent != null && !stateComponent.isEmpty() && Boolean.TRUE.equals(stateComponent.get((Property)SculkShriekerBlock.CAN_SUMMON))) {
            lines.add((Component)Component.translatable((String)"pastel.tooltip.able_to_summon_warden").withStyle(ChatFormatting.GRAY));
        }
    }

    private static void addSignTooltips(List<Component> lines, DataComponentMap components) {
        CustomData dataComponent = (CustomData)components.get(DataComponents.BLOCK_ENTITY_DATA);
        if (dataComponent == null) {
            return;
        }
        CompoundTag blockEntityTag = dataComponent.getUnsafe().getCompound("BlockEntityTag");
        PastelTooltips.addSignText(lines, (DataResult<SignText>)SignText.DIRECT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)blockEntityTag.getCompound("front_text")));
        PastelTooltips.addSignText(lines, (DataResult<SignText>)SignText.DIRECT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)blockEntityTag.getCompound("back_text")));
    }

    private static void addSignText(List<Component> lines, DataResult<SignText> signText) {
        if (signText.result().isPresent()) {
            SignText st = (SignText)signText.result().get();
            Style style = Style.EMPTY.withColor(st.getColor().getTextColor());
            for (Component text : st.getMessages(false)) {
                lines.addAll(text.toFlatList(style));
            }
        }
    }

    public static void addSpawnerTooltips(List<Component> lines, DataComponentMap components) {
        CustomData dataComponent = (CustomData)components.get(DataComponents.BLOCK_ENTITY_DATA);
        if (dataComponent == null) {
            return;
        }
        CompoundTag blockEntityTag = dataComponent.copyTag();
        try {
            short spawnCount = blockEntityTag.getShort("SpawnCount");
            short minSpawnDelay = blockEntityTag.getShort("MinSpawnDelay");
            short maxSpawnDelay = blockEntityTag.getShort("MaxSpawnDelay");
            short spawnRange = blockEntityTag.getShort("SpawnRange");
            short requiredPlayerRange = blockEntityTag.getShort("RequiredPlayerRange");
            short maxNearbyEntities = blockEntityTag.getShort("MaxNearbyEntities");
            if (spawnCount > 0) {
                lines.add((Component)Component.translatable((String)"item.pastel.spawner.tooltip.spawn_count", (Object[])new Object[]{spawnCount}).withStyle(ChatFormatting.GRAY));
            }
            if (minSpawnDelay > 0) {
                lines.add((Component)Component.translatable((String)"item.pastel.spawner.tooltip.min_spawn_delay", (Object[])new Object[]{minSpawnDelay}).withStyle(ChatFormatting.GRAY));
            }
            if (maxSpawnDelay > 0) {
                lines.add((Component)Component.translatable((String)"item.pastel.spawner.tooltip.max_spawn_delay", (Object[])new Object[]{maxSpawnDelay}).withStyle(ChatFormatting.GRAY));
            }
            if (spawnRange > 0) {
                lines.add((Component)Component.translatable((String)"item.pastel.spawner.tooltip.spawn_range", (Object[])new Object[]{spawnRange}).withStyle(ChatFormatting.GRAY));
            }
            if (requiredPlayerRange > 0) {
                lines.add((Component)Component.translatable((String)"item.pastel.spawner.tooltip.required_player_range", (Object[])new Object[]{requiredPlayerRange}).withStyle(ChatFormatting.GRAY));
            }
            if (maxNearbyEntities > 0) {
                lines.add((Component)Component.translatable((String)"item.pastel.spawner.tooltip.max_nearby_entities", (Object[])new Object[]{maxNearbyEntities}).withStyle(ChatFormatting.GRAY));
            }
        }
        catch (Exception e) {
            lines.add((Component)Component.translatable((String)"item.pastel.spawner.tooltip.unknown_mob"));
        }
    }
}

