/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries.client;

import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.client.PastelModelLayers;
import earth.terrarium.pastel.render.armor.BedrockArmorModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredItem;

public class PastelArmorRenderers {
    public static final DeferredItem<?>[] BEDROCK_ARMOR = new DeferredItem[]{PastelItems.BEDROCK_HELMET, PastelItems.BEDROCK_CHESTPLATE, PastelItems.BEDROCK_LEGGINGS, PastelItems.BEDROCK_BOOTS};

    public static void register(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private Map<EquipmentSlot, HumanoidModel<LivingEntity>> models = new Object2ObjectArrayMap();

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return this.models.computeIfAbsent(equipmentSlot, this::provideArmorModelForSlot);
            }

            private HumanoidModel<LivingEntity> provideArmorModelForSlot(EquipmentSlot slot) {
                EntityModelSet models = Minecraft.getInstance().getEntityModels();
                ModelPart root = models.bakeLayer(PastelModelLayers.MAIN_BEDROCK_LAYER);
                return new BedrockArmorModel(root, slot);
            }
        }, BEDROCK_ARMOR);
    }
}

