/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries.client;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.InkPoweredStatusEffectInstance;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.energy.storage.SingleInkStorage;
import earth.terrarium.pastel.blocks.conditional.colored_tree.ColoredLeavesBlock;
import earth.terrarium.pastel.blocks.memory.MemoryBlockEntity;
import earth.terrarium.pastel.blocks.memory.MemoryItem;
import earth.terrarium.pastel.components.InfusedBeverageComponent;
import earth.terrarium.pastel.items.energy.InkFlaskItem;
import earth.terrarium.pastel.progression.ToggleableBlockColorProvider;
import earth.terrarium.pastel.progression.ToggleableItemColorProvider;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.List;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class PastelColorProviders {
    public static ToggleableBlockColorProvider coloredLeavesBlockColorProvider;
    public static ToggleableItemColorProvider coloredLeavesItemColorProvider;
    public static ToggleableBlockColorProvider amaranthBushelBlockColorProvider;
    public static ToggleableItemColorProvider amaranthBushelItemColorProvider;
    public static ToggleableBlockColorProvider amaranthCropBlockColorProvider;
    public static ToggleableItemColorProvider amaranthCropItemColorProvider;
    private static final BlockColor THAT_ONE_VANILLA_LEAF_PROVIDER;
    private static final BlockColor THE_OTHER_ONE_AKA_GRASS;
    private static final ItemColor THAT_ONE_VANILLA_ITEM_PROVIDER;
    private static final ItemColor YES_THERE_IS_ANOTHER_ITEM_ONE_TOO;

    public static void registerBlocks(RegisterColorHandlersEvent.Block event) {
        PastelCommon.logInfo("Registering Block Color Providers...");
        PastelColorProviders.coloredLeavesBlock(event);
        PastelColorProviders.amaranthBlock(event);
        event.register(THE_OTHER_ONE_AKA_GRASS, new Block[]{(Block)PastelBlocks.CLOVER.get(), (Block)PastelBlocks.FOUR_LEAF_CLOVER.get()});
        PastelColorProviders.memoryBlock(event, (Block)PastelBlocks.MEMORY.get());
    }

    public static void registerItems(RegisterColorHandlersEvent.Item event) {
        PastelCommon.logInfo("Registering Item Color Providers...");
        PastelColorProviders.coloredLeavesItem(event);
        PastelColorProviders.amaranthItem(event);
        event.register(YES_THERE_IS_ANOTHER_ITEM_ONE_TOO, new ItemLike[]{(ItemLike)PastelBlocks.CLOVER.get(), (ItemLike)PastelBlocks.FOUR_LEAF_CLOVER.get()});
        PastelColorProviders.memoryItem(event, (Block)PastelBlocks.MEMORY.get());
        PastelColorProviders.registerPotionFillables(event, (Item)PastelItems.LESSER_POTION_PENDANT.get(), (Item)PastelItems.GREATER_POTION_PENDANT.get(), (Item)PastelItems.MALACHITE_GLASS_AMPOULE.get());
        PastelColorProviders.registerPickyPotionFillables(event, (Item)PastelItems.NIGHTFALLS_BLADE.get(), (Item)PastelItems.CONCEALING_OILS.get());
        PastelColorProviders.registerSingleInkStorages(event, (Item)PastelItems.INK_FLASK.get());
        PastelColorProviders.registerBrewColors(event, (Item)PastelItems.INFUSED_BEVERAGE.get());
        PastelColorProviders.registerOptionalInkColor(event, (Item)PastelItems.PAINTBRUSH.get());
    }

    private static void coloredLeavesBlock(RegisterColorHandlersEvent.Block event) {
        coloredLeavesBlockColorProvider = new ToggleableBlockColorProvider(THAT_ONE_VANILLA_LEAF_PROVIDER);
        for (InkColor color : InkColors.all()) {
            ColoredLeavesBlock block = ColoredLeavesBlock.byColor(color);
            event.register((BlockColor)coloredLeavesBlockColorProvider, new Block[]{block});
        }
    }

    private static void coloredLeavesItem(RegisterColorHandlersEvent.Item event) {
        coloredLeavesItemColorProvider = new ToggleableItemColorProvider(THAT_ONE_VANILLA_ITEM_PROVIDER);
        for (InkColor color : InkColors.all()) {
            ColoredLeavesBlock block = ColoredLeavesBlock.byColor(color);
            event.register((ItemColor)coloredLeavesItemColorProvider, new ItemLike[]{block});
        }
    }

    private static void amaranthBlock(RegisterColorHandlersEvent.Block event) {
        amaranthCropBlockColorProvider = new ToggleableBlockColorProvider(THE_OTHER_ONE_AKA_GRASS);
        amaranthBushelBlockColorProvider = new ToggleableBlockColorProvider(THE_OTHER_ONE_AKA_GRASS);
        event.register((BlockColor)amaranthCropBlockColorProvider, new Block[]{(Block)PastelBlocks.AMARANTH.get()});
        event.register((BlockColor)amaranthBushelBlockColorProvider, new Block[]{(Block)PastelBlocks.AMARANTH_BUSHEL.get()});
        event.register((BlockColor)amaranthBushelBlockColorProvider, new Block[]{(Block)PastelBlocks.POTTED_AMARANTH_BUSHEL.get()});
    }

    private static void amaranthItem(RegisterColorHandlersEvent.Item event) {
        amaranthCropItemColorProvider = new ToggleableItemColorProvider(YES_THERE_IS_ANOTHER_ITEM_ONE_TOO);
        amaranthBushelItemColorProvider = new ToggleableItemColorProvider(YES_THERE_IS_ANOTHER_ITEM_ONE_TOO);
        event.register((ItemColor)amaranthCropItemColorProvider, new ItemLike[]{(ItemLike)PastelBlocks.AMARANTH.get()});
        event.register((ItemColor)amaranthBushelItemColorProvider, new ItemLike[]{(ItemLike)PastelBlocks.AMARANTH_BUSHEL.get()});
    }

    private static void registerSingleInkStorages(RegisterColorHandlersEvent.Item event, Item ... items) {
        event.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                InkFlaskItem i = (InkFlaskItem)stack.getItem();
                SingleInkStorage storage = i.getEnergyStorage(stack);
                return FastColor.ARGB32.opaque((int)storage.getStoredColor().getColorInt());
            }
            return -1;
        }, (ItemLike[])items);
    }

    private static void registerPickyPotionFillables(RegisterColorHandlersEvent.Item event, Item ... items) {
        event.register((stack, tintIndex) -> {
            List<InkPoweredStatusEffectInstance> effects;
            if (tintIndex == 1 && !(effects = InkPoweredStatusEffectInstance.getEffects(stack)).isEmpty()) {
                return FastColor.ARGB32.opaque((int)effects.getFirst().getColor());
            }
            return -1;
        }, (ItemLike[])items);
    }

    private static void registerPotionFillables(RegisterColorHandlersEvent.Item event, Item ... items) {
        event.register((stack, tintIndex) -> {
            List<InkPoweredStatusEffectInstance> effects;
            if (tintIndex > 0 && (effects = InkPoweredStatusEffectInstance.getEffects(stack)).size() > tintIndex - 1) {
                return FastColor.ARGB32.opaque((int)effects.get(tintIndex - 1).getColor());
            }
            return -1;
        }, (ItemLike[])items);
    }

    private static void memoryBlock(RegisterColorHandlersEvent.Block event, Block memory) {
        event.register((state, world, pos, tintIndex) -> {
            if (world == null) {
                return 0;
            }
            BlockEntity patt0$temp = world.getBlockEntity(pos);
            if (patt0$temp instanceof MemoryBlockEntity) {
                MemoryBlockEntity memoryBlockEntity = (MemoryBlockEntity)patt0$temp;
                return memoryBlockEntity.getEggColor(tintIndex);
            }
            return 0;
        }, new Block[]{memory});
    }

    private static void memoryItem(RegisterColorHandlersEvent.Item event, Block memory) {
        event.register((stack, tintIndex) -> {
            if (tintIndex == 2) {
                return -1;
            }
            return FastColor.ARGB32.opaque((int)MemoryItem.getEggColor(stack, tintIndex));
        }, new ItemLike[]{memory.asItem()});
    }

    public static void registerBrewColors(RegisterColorHandlersEvent.Item event, Item brew) {
        event.register((stack, tintIndex) -> {
            if (tintIndex != 0) {
                return FastColor.ARGB32.opaque((int)-1);
            }
            return FastColor.ARGB32.opaque((int)((InfusedBeverageComponent)stack.getOrDefault(PastelDataComponentTypes.INFUSED_BEVERAGE, (Object)InfusedBeverageComponent.DEFAULT)).color());
        }, new ItemLike[]{brew});
    }

    public static void registerOptionalInkColor(RegisterColorHandlersEvent.Item event, Item item) {
        event.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                InkColor color = (InkColor)stack.get(PastelDataComponentTypes.INK_COLOR);
                return FastColor.ARGB32.opaque((int)(color == null ? -1 : color.getColorInt()));
            }
            return -1;
        }, new ItemLike[]{item});
    }

    public static void resetToggleableProviders() {
        coloredLeavesBlockColorProvider.setShouldApply(false);
        coloredLeavesItemColorProvider.setShouldApply(false);
        amaranthBushelBlockColorProvider.setShouldApply(false);
        amaranthBushelItemColorProvider.setShouldApply(false);
        amaranthCropBlockColorProvider.setShouldApply(false);
        amaranthCropItemColorProvider.setShouldApply(false);
    }

    static {
        THAT_ONE_VANILLA_LEAF_PROVIDER = (state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.getDefaultColor();
        THE_OTHER_ONE_AKA_GRASS = (state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.getDefaultColor();
        THAT_ONE_VANILLA_ITEM_PROVIDER = (stack, tint) -> {
            BlockState blockstate = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
            return THAT_ONE_VANILLA_LEAF_PROVIDER.getColor(blockstate, null, null, tint);
        };
        YES_THERE_IS_ANOTHER_ITEM_ONE_TOO = (stack, tint) -> {
            BlockState blockstate = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
            return THE_OTHER_ONE_AKA_GRASS.getColor(blockstate, null, null, tint);
        };
    }
}

