/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries.client;

import earth.terrarium.pastel.registries.client.PastelModels;
import earth.terrarium.pastel.registries.client.PastelTextureKeys;
import earth.terrarium.pastel.registries.client.PastelTextureMaps;
import earth.terrarium.pastel.registries.client.PastelTextures;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PastelTexturedModels {
    public static final TexturedModel.Provider BASE_TRANS_LIGHT_CORE = TexturedModel.createDefault(b -> new TextureMapping().put(PastelTextureKeys.CASE, TextureMapping.getBlockTexture((Block)b)).put(PastelTextureKeys.BASE, TextureMapping.getBlockTexture((Block)b, (String)"_base")).put(PastelTextureKeys.GLASS, TextureMapping.getBlockTexture((Block)b, (String)"_glass")).put(PastelTextureKeys.SHELL, TextureMapping.getBlockTexture((Block)b, (String)"_shell")).put(PastelTextureKeys.FILAMENT, TextureMapping.getBlockTexture((Block)b, (String)"_filament")).put(PastelTextureKeys.ENDS, TextureMapping.getBlockTexture((Block)b, (String)"_ends")), (ModelTemplate)PastelModels.BASE_TRANS_LIGHT_CORE);
    public static final TexturedModel.Provider BOWL = TexturedModel.createDefault(b -> new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)b, (String)"_side")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)b, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)b, (String)"_bottom")).put(PastelTextureKeys.INNER, TextureMapping.getBlockTexture((Block)b, (String)"_inner")), (ModelTemplate)PastelModels.BOWL);
    public static final TexturedModel.Provider CHIME = TexturedModel.createDefault(b -> new TextureMapping().put(PastelTextureKeys.BASE, PastelTextures.BALCITE_CHIME_BASE).put(PastelTextureKeys.GEMSTONE, TextureMapping.getBlockTexture((Block)b)), (ModelTemplate)PastelModels.CHIME);
    public static final TexturedModel.Provider CUBE_COLUMN_MIRRORED = TexturedModel.createDefault(TextureMapping::logColumn, (ModelTemplate)ModelTemplates.CUBE_COLUMN_MIRRORED);
    public static final TexturedModel.Provider CUSHION = TexturedModel.createDefault(b -> PastelTextureMaps.sideTopBottom(b, "_side", b, "_top", b, "_bottom"), (ModelTemplate)PastelModels.CUSHION);
    public static final TexturedModel.Provider FUSION_SHRINE = TexturedModel.createDefault(b -> new TextureMapping().put(PastelTextureKeys.SHRINE, TextureMapping.getBlockTexture((Block)b)).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)b, (String)"_breaking")), (ModelTemplate)PastelModels.FUSION_SHRINE);
    public static final TexturedModel.Provider ROUNDEL = TexturedModel.createDefault(b -> new TextureMapping().put(TextureSlot.ALL, TextureMapping.getBlockTexture((Block)b)), (ModelTemplate)PastelModels.ROUNDEL);
    public static final TexturedModel.Provider SHOOTING_STAR = TexturedModel.createDefault(b -> new TextureMapping().put(PastelTextureKeys.CORE, TextureMapping.getBlockTexture((Block)b)).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)b, (String)"_side")), (ModelTemplate)PastelModels.SHOOTING_STAR);

    public static TexturedModel.Provider baseTransLantern(boolean diagonal, boolean tall) {
        return TexturedModel.createDefault(b -> new TextureMapping().put(PastelTextureKeys.GLASS, TextureMapping.getBlockTexture((Block)b, (String)"_glass_on")).put(PastelTextureKeys.CASE, TextureMapping.getBlockTexture((Block)b, (String)"_case_on")), (ModelTemplate)PastelModels.baseTransLantern(diagonal, tall));
    }

    public static TexturedModel.Provider carpet(UnaryOperator<Block> woolBlock, String woolSuffix) {
        return TexturedModel.createDefault(b -> TextureMapping.wool((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)woolBlock.apply((Block)b)), (String)woolSuffix)), (ModelTemplate)ModelTemplates.CARPET);
    }

    public static TexturedModel.Provider complexOrientable(UnaryOperator<Block> sideBlock, String sideSuffix, UnaryOperator<Block> topBlock, String topSuffix, UnaryOperator<Block> bottomBlock, String bottomSuffix, UnaryOperator<Block> frontBlock, String frontSuffix, UnaryOperator<Block> backBlock, String backSuffix, UnaryOperator<Block> particleBlock, String particleSuffix) {
        return TexturedModel.createDefault(b -> new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)sideBlock.apply((Block)b)), (String)sideSuffix)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)topBlock.apply((Block)b)), (String)topSuffix)).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)((Block)bottomBlock.apply((Block)b)), (String)bottomSuffix)).put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)((Block)frontBlock.apply((Block)b)), (String)frontSuffix)).put(TextureSlot.BACK, TextureMapping.getBlockTexture((Block)((Block)backBlock.apply((Block)b)), (String)backSuffix)).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)((Block)particleBlock.apply((Block)b)), (String)particleSuffix)), (ModelTemplate)PastelModels.COMPLEX_ORIENTABLE);
    }

    public static TexturedModel.Provider cross(UnaryOperator<Block> crossBlock, String crossSuffix) {
        return TexturedModel.createDefault(b -> PastelTextureMaps.cross((Block)crossBlock.apply((Block)b), crossSuffix), (ModelTemplate)ModelTemplates.CROSS);
    }

    public static TexturedModel.Provider cubeAll(UnaryOperator<Block> allBlock, String allSuffix) {
        return TexturedModel.createDefault(b -> PastelTextureMaps.all((Block)allBlock.apply((Block)b), allSuffix), (ModelTemplate)ModelTemplates.CUBE_ALL);
    }

    public static TexturedModel.Provider cubeBottomTop(UnaryOperator<Block> sideBlock, String sideSuffix, UnaryOperator<Block> topBlock, String topSuffix, UnaryOperator<Block> bottomBlock, String bottomSuffix) {
        return TexturedModel.createDefault(b -> PastelTextureMaps.sideTopBottom((Block)sideBlock.apply((Block)b), sideSuffix, (Block)topBlock.apply((Block)b), topSuffix, (Block)bottomBlock.apply((Block)b), bottomSuffix), (ModelTemplate)ModelTemplates.CUBE_BOTTOM_TOP);
    }

    public static TexturedModel.Provider cubeBottomTopParticle(UnaryOperator<Block> sideBlock, String sideSuffix, UnaryOperator<Block> topBlock, String topSuffix, UnaryOperator<Block> bottomBlock, String bottomSuffix, UnaryOperator<Block> particleBlock, String particleSuffix) {
        return TexturedModel.createDefault(b -> PastelTextureMaps.sideTopBottomParticle((Block)sideBlock.apply((Block)b), sideSuffix, (Block)topBlock.apply((Block)b), topSuffix, (Block)bottomBlock.apply((Block)b), bottomSuffix, (Block)particleBlock.apply((Block)b), particleSuffix), (ModelTemplate)PastelModels.CUBE_BOTTOM_TOP_PARTICLE);
    }

    public static TexturedModel.Provider cubeBottomTopWall(UnaryOperator<Block> sideBlock, String sideSuffix, UnaryOperator<Block> topBlock, String topSuffix, UnaryOperator<Block> bottomBlock, String bottomSuffix, UnaryOperator<Block> wallBlock, String wallSuffix) {
        return TexturedModel.createDefault(b -> PastelTextureMaps.sideTopBottomWall((Block)sideBlock.apply((Block)b), sideSuffix, (Block)topBlock.apply((Block)b), topSuffix, (Block)bottomBlock.apply((Block)b), bottomSuffix, (Block)wallBlock.apply((Block)b), wallSuffix), (ModelTemplate)PastelModels.CUBE_BOTTOM_TOP_WALL);
    }

    public static TexturedModel.Provider cubeColumn(UnaryOperator<Block> sideBlock, String sideSuffix, UnaryOperator<Block> endBlock, String endSuffix) {
        return TexturedModel.createDefault(b -> PastelTextureMaps.sideEnd((Block)sideBlock.apply((Block)b), sideSuffix, (Block)endBlock.apply((Block)b), endSuffix), (ModelTemplate)ModelTemplates.CUBE_COLUMN);
    }

    public static TexturedModel.Provider doubleCross(UnaryOperator<Block> crossBlock, String crossSuffix) {
        return TexturedModel.createDefault(b -> PastelTextureMaps.cross((Block)crossBlock.apply((Block)b), crossSuffix), (ModelTemplate)PastelModels.DOUBLE_CROSS);
    }

    public static TexturedModel.Provider farmland(UnaryOperator<Block> dirtBlock, String dirtSuffix, UnaryOperator<Block> topBlock, String topSuffix) {
        return TexturedModel.createDefault(b -> new TextureMapping().put(TextureSlot.DIRT, TextureMapping.getBlockTexture((Block)((Block)dirtBlock.apply((Block)b)), (String)dirtSuffix)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)topBlock.apply((Block)b)), (String)topSuffix)), (ModelTemplate)ModelTemplates.FARMLAND);
    }

    public static TexturedModel.Provider flowerPotCross(UnaryOperator<Block> plantBlock, String plantSuffix, boolean tinted) {
        BlockModelGenerators.TintState tintType = tinted ? BlockModelGenerators.TintState.TINTED : BlockModelGenerators.TintState.NOT_TINTED;
        return TexturedModel.createDefault(b -> PastelTextureMaps.plant((Block)plantBlock.apply((Block)b), plantSuffix), (ModelTemplate)tintType.getCrossPot());
    }

    public static TexturedModel.Provider leaves(UnaryOperator<Block> allBlock, String allSuffix) {
        return TexturedModel.createDefault(b -> PastelTextureMaps.all((Block)allBlock.apply((Block)b), allSuffix), (ModelTemplate)ModelTemplates.LEAVES);
    }

    public static TexturedModel.Provider overgrown(UnaryOperator<Block> sideBlock, String sideSuffix, UnaryOperator<Block> topBlock, String topSuffix, UnaryOperator<Block> bottomBlock, String bottomSuffix, UnaryOperator<Block> frondsBlock, String frondsSuffix) {
        return TexturedModel.createDefault(b -> PastelTextureMaps.sideTopBottomFronds((Block)sideBlock.apply((Block)b), sideSuffix, (Block)topBlock.apply((Block)b), topSuffix, (Block)bottomBlock.apply((Block)b), bottomSuffix, (Block)frondsBlock.apply((Block)b), frondsSuffix), (ModelTemplate)PastelModels.OVERGROWN);
    }

    public static TexturedModel.Provider parented(ResourceLocation parentModelId) {
        return TexturedModel.createDefault(b -> new TextureMapping(), (ModelTemplate)new ModelTemplate(Optional.of(parentModelId), Optional.empty(), new TextureSlot[0]));
    }

    public static TexturedModel.Provider particle(UnaryOperator<Block> particleBlock, String particleSuffix) {
        return TexturedModel.createDefault(b -> TextureMapping.particle((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)particleBlock.apply((Block)b)), (String)particleSuffix)), (ModelTemplate)ModelTemplates.PARTICLE_ONLY);
    }

    public static TexturedModel.Provider particle(ResourceLocation particle) {
        return TexturedModel.createDefault(b -> TextureMapping.particle((ResourceLocation)particle), (ModelTemplate)ModelTemplates.PARTICLE_ONLY);
    }

    public static TexturedModel.Provider sugarStick(int age, UnaryOperator<Block> sugarBlock) {
        return TexturedModel.createDefault(b -> new TextureMapping().put(PastelTextureKeys.KEY0, TextureMapping.getBlockTexture((Block)((Block)sugarBlock.apply((Block)b)))).put(PastelTextureKeys.KEY1, TextureMapping.getBlockTexture((Block)Blocks.OAK_PLANKS)).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)((Block)sugarBlock.apply((Block)b)))), (ModelTemplate)PastelModels.sugarStick(age));
    }

    public static TexturedModel.Provider tintableCross(UnaryOperator<Block> crossBlock, String crossSuffix, boolean tinted) {
        BlockModelGenerators.TintState tintType = tinted ? BlockModelGenerators.TintState.TINTED : BlockModelGenerators.TintState.NOT_TINTED;
        return TexturedModel.createDefault(b -> PastelTextureMaps.cross((Block)crossBlock.apply((Block)b), crossSuffix), (ModelTemplate)tintType.getCross());
    }
}

