/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import earth.terrarium.pastel.registries.PastelBiomes;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.sound.WorldAttenuation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public class BiomeSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    @Nullable
    public static BiomeSoundInstance WIND_HIGH = null;
    @Nullable
    public static BiomeSoundInstance WIND_LOW = null;
    @Nullable
    public static BiomeSoundInstance SHOWER = null;
    @Nullable
    public static BiomeSoundInstance LAMENTS = null;
    private static boolean clear = true;
    private final Minecraft client = Minecraft.getInstance();
    private static final int MAX_DURATION = 80;
    private final ResourceKey<Biome> biome;
    private final float volumeMod;
    private int biomeTicks = 1;
    private final boolean deepPitch;
    private boolean finished;

    protected BiomeSoundInstance(ResourceKey<Biome> biome, SoundEvent sound, float volumeMod, boolean altMod) {
        super(sound, SoundSource.AMBIENT, SoundInstance.createUnseededRandom());
        this.looping = true;
        this.delay = 0;
        this.biome = biome;
        this.volumeMod = volumeMod;
        this.deepPitch = altMod;
        this.relative = false;
        this.updateVolumeAndPitch();
    }

    public void tick() {
        Entity camera = this.client.getCameraEntity();
        if (camera == null) {
            this.finished = true;
            return;
        }
        Level world = camera.level();
        if (world.getBiome(camera.blockPosition()).is(this.biome) && this.biomeTicks < 80) {
            ++this.biomeTicks;
        } else if (this.biomeTicks > 0) {
            --this.biomeTicks;
        }
        this.updateVolumeAndPitch();
        this.updatePosition(camera);
    }

    private void updatePosition(Entity camera) {
        WorldAttenuation.Data data = WorldAttenuation.getData();
        this.x = camera.getX() + (double)data.x() * 3.5;
        this.y = camera.getY() + 1.0 + (double)(data.y() * 2.0f);
        this.z = camera.getZ() + (double)data.z() * 3.5;
    }

    private void updateVolumeAndPitch() {
        WorldAttenuation.Data data = WorldAttenuation.getData();
        float volMod = data.volume();
        float pitchMod = data.pitch();
        if (this.deepPitch) {
            volMod = volMod * 0.75f + 0.05f;
            pitchMod = pitchMod * 0.9f + 0.1f;
        } else {
            volMod = Math.max(0.02f, volMod);
            pitchMod = Math.max(0.4f, pitchMod * 1.1f);
        }
        volMod = Math.clamp(volMod * 2.0f, 0.0f, 1.0f);
        this.volume = Math.max(0.0f, (float)this.biomeTicks / 80.0f) * this.volumeMod * volMod;
        this.pitch = pitchMod;
    }

    public boolean isStopped() {
        return this.biomeTicks == 0 || this.finished;
    }

    public static void update(Holder<Biome> biome) {
        Minecraft client = Minecraft.getInstance();
        clear = false;
        if (WIND_HIGH != null && WIND_HIGH.isStopped()) {
            WIND_HIGH = null;
        }
        if (WIND_LOW != null && WIND_LOW.isStopped()) {
            WIND_LOW = null;
        }
        if (SHOWER != null && SHOWER.isStopped()) {
            SHOWER = null;
        }
        if (LAMENTS != null && LAMENTS.isStopped()) {
            LAMENTS = null;
        }
        if (biome.is(PastelBiomes.HOWLING_SPIRES)) {
            if (WIND_HIGH == null) {
                WIND_HIGH = new BiomeSoundInstance(PastelBiomes.HOWLING_SPIRES, PastelSounds.HOWLING_WIND_HIGH, 0.45f, false);
                client.getSoundManager().play((SoundInstance)WIND_HIGH);
            }
            if (WIND_LOW == null) {
                WIND_LOW = new BiomeSoundInstance(PastelBiomes.HOWLING_SPIRES, PastelSounds.HOWLING_WIND_LOW, 1.3f, true);
                client.getSoundManager().play((SoundInstance)WIND_LOW);
            }
        } else if (biome.is(PastelBiomes.DEEP_DRIPSTONE_CAVES)) {
            if (SHOWER == null) {
                SHOWER = new BiomeSoundInstance(PastelBiomes.DEEP_DRIPSTONE_CAVES, PastelSounds.SHOWER, 0.425f, false);
                client.getSoundManager().play((SoundInstance)SHOWER);
            }
        } else if (biome.is(PastelBiomes.DRAGONROT_SWAMP)) {
            if (LAMENTS == null) {
                LAMENTS = new BiomeSoundInstance(PastelBiomes.DRAGONROT_SWAMP, PastelSounds.LAMENTS, 1.0f, true);
                client.getSoundManager().play((SoundInstance)LAMENTS);
            }
            if (SHOWER == null) {
                SHOWER = new BiomeSoundInstance(PastelBiomes.DRAGONROT_SWAMP, PastelSounds.SHOWER, 1.0f, false);
                client.getSoundManager().play((SoundInstance)SHOWER);
            }
        }
    }

    public static void clear() {
        if (clear) {
            return;
        }
        if (WIND_HIGH != null) {
            BiomeSoundInstance.WIND_HIGH.finished = true;
            WIND_HIGH = null;
        }
        if (WIND_LOW != null) {
            BiomeSoundInstance.WIND_LOW.finished = true;
            WIND_LOW = null;
        }
        if (SHOWER != null) {
            BiomeSoundInstance.SHOWER.finished = true;
            SHOWER = null;
        }
        if (LAMENTS != null) {
            BiomeSoundInstance.LAMENTS.finished = true;
            LAMENTS = null;
        }
        clear = true;
    }
}

