/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnderSpliceChargingSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private final Player player;
    private boolean done;

    public EnderSpliceChargingSoundInstance(Player player) {
        super(PastelSounds.ENDER_SPLICE_CHARGES, SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.looping = true;
        this.delay = 0;
        this.volume = 0.6f;
        this.player = player;
        this.x = player.getX();
        this.y = player.getY();
        this.z = player.getZ();
    }

    public boolean isStopped() {
        return this.done;
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        if (this.player == null || this.player.getUseItemRemainingTicks() <= 0 || this.player.getTicksUsingItem() > 47 || !this.player.getUseItem().is((Item)PastelItems.ENDER_SPLICE.get())) {
            this.setDone();
        } else {
            this.x = this.player.getX();
            this.y = this.player.getY();
            this.z = this.player.getZ();
            this.showParticles();
        }
    }

    private void showParticles() {
        Level world = this.player.getCommandSenderWorld();
        Vec3 pos = this.player.position();
        RandomSource random = world.random;
        for (int i = 0; i < 10; ++i) {
            this.player.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.PORTAL, pos.x, pos.y + 1.0, pos.z, random.nextDouble() * 1.6 - 0.8, random.nextDouble() * 1.6 - 0.8, random.nextDouble() * 1.6 - 0.8);
        }
    }

    protected final void setDone() {
        this.done = true;
        this.looping = false;
    }
}

