/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.registries.PastelLevels;
import earth.terrarium.pastel.sound.WorldAttenuation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.EXTEfx;

@OnlyIn(value=Dist.CLIENT)
public class PastelSourceEffects {
    public static final Logger LOGGER = LogManager.getLogger();
    public static int effect = -1;
    public static int filter = -1;
    public static int slot = -1;

    public static void updateSlots() {
        try {
            effect = EXTEfx.alGenEffects();
            filter = EXTEfx.alGenFilters();
            slot = EXTEfx.alGenAuxiliaryEffectSlots();
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARN, "Error updating reverb filter. No audio devices present?");
        }
    }

    public static void tick(SoundInstance soundInstance, int sourceID) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        if (client.level.dimension().location() != PastelLevels.DIMENSION_ID) {
            return;
        }
        if (!(PastelCommon.CONFIG.DimensionReverbDecayTime > 0.0f) && !(PastelCommon.CONFIG.DimensionReverbDensity > 0.0f)) {
            return;
        }
        ResourceLocation identifier = soundInstance.getLocation();
        if (identifier.getPath().contains("ui.") || identifier.getPath().contains("music.") || identifier.getPath().contains("block.lava.pop") || identifier.getPath().contains("weather.") || identifier.getPath().startsWith("atmosfera") || identifier.getPath().startsWith("dynmus")) {
            return;
        }
        AL11.alSourcei((int)sourceID, (int)131077, (int)0);
        if (effect == -1 || filter == -1 || slot == -1) {
            PastelSourceEffects.updateSlots();
        }
        EXTEfx.alAuxiliaryEffectSlotf((int)slot, (int)2, (float)0.0f);
        WorldAttenuation.Data data = WorldAttenuation.getData();
        PastelSourceEffects.updateEffects(data);
        PastelSourceEffects.updateFilters(data);
        EXTEfx.alAuxiliaryEffectSloti((int)slot, (int)1, (int)effect);
        EXTEfx.alAuxiliaryEffectSlotf((int)slot, (int)2, (float)1.0f);
        AL11.alSourcei((int)sourceID, (int)131077, (int)filter);
        AL11.alSource3i((int)sourceID, (int)131078, (int)slot, (int)0, (int)0);
        int error = AL11.alGetError();
        if (error != 0) {
            LOGGER.warn("OpenAl Error {}", (Object)error);
        }
    }

    private static void updateEffects(WorldAttenuation.Data data) {
        EXTEfx.alEffecti((int)effect, (int)32769, (int)1);
        EXTEfx.alEffectf((int)effect, (int)1, (float)Mth.clamp((float)(PastelCommon.CONFIG.DimensionReverbDensity * data.pitch()), (float)0.0f, (float)1.0f));
        EXTEfx.alEffectf((int)effect, (int)5, (float)Mth.clamp((float)(PastelCommon.CONFIG.DimensionReverbDecayTime * Math.max(data.volume() * 1.65f, 0.2f)), (float)0.1f, (float)20.0f));
    }

    private static void updateFilters(WorldAttenuation.Data data) {
        EXTEfx.alFilteri((int)filter, (int)32769, (int)1);
        EXTEfx.alFilterf((int)filter, (int)1, (float)Math.clamp(data.filtering() * 2.0f, 0.0f, 1.0f));
        EXTEfx.alFilterf((int)filter, (int)2, (float)Math.clamp(data.filtering() * data.pitch(), 0.0f, 1.0f));
    }
}

