/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.blocks.deeper_down.groundcover.AshPileBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.worldgen.features.AshDunesFeatureConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class AshDunesFeature
extends Feature<AshDunesFeatureConfig> {
    private static final IntegerProperty LAYERS = AshPileBlock.LAYERS;

    public AshDunesFeature(Codec<AshDunesFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<AshDunesFeatureConfig> context) {
        int i;
        BlockPos origin = context.origin();
        AshDunesFeatureConfig config = (AshDunesFeatureConfig)context.config();
        RandomSource random = context.random();
        WorldGenLevel world = context.level();
        boolean bias = random.nextBoolean();
        IntProvider spreadProvider = config.nodeSpread();
        FloatProvider strengthProvider = config.emitterStrength();
        int nodeQuantity = config.nodeQuantity().sample(random);
        int cutoutQuantity = config.cutoutQuantity().sample(random);
        float decay = config.emitterDecayModifier();
        ArrayList<Emitter> emitters = new ArrayList<Emitter>();
        for (i = 0; i < nodeQuantity; ++i) {
            AshDunesFeature.generateEmitter(origin, false, bias, spreadProvider, random, world, emitters, strengthProvider.sample(random));
        }
        if (emitters.isEmpty()) {
            return false;
        }
        for (i = 0; i < cutoutQuantity; ++i) {
            AshDunesFeature.generateEmitter(origin, true, bias, spreadProvider, random, world, emitters, strengthProvider.sample(random) / 1.667f);
        }
        emitters.add(new Emitter(origin.mutable(), strengthProvider.sample(random), false));
        int placementArea = spreadProvider.getMaxValue() + Math.round(strengthProvider.getMaxValue() / decay);
        Iterator iterator = BlockPos.withinManhattan((BlockPos)origin, (int)placementArea, (int)0, (int)placementArea).iterator();
        boolean anyPlaced = false;
        while (iterator.hasNext()) {
            int height;
            BlockPos.MutableBlockPos placementPos = ((BlockPos)iterator.next()).mutable();
            int originalY = placementPos.getY();
            if (!world.getBlockState((BlockPos)placementPos).is((Block)PastelBlocks.ASH_PILE.get()) && !AshDunesFeature.canPlaceAt(world, (BlockPos)placementPos) && !this.adjustPlacementHeight(world, placementPos, placementArea / 3) || (height = Math.round(this.getStrengthAt((BlockPos)placementPos, origin, emitters, originalY, placementArea, decay, config.emitterCutoutModifier()))) <= 0) continue;
            this.placeAsh(world, placementPos, height);
            anyPlaced = true;
        }
        return anyPlaced;
    }

    private static void generateEmitter(BlockPos origin, boolean cutout, boolean bias, IntProvider spreadProvider, RandomSource random, WorldGenLevel world, List<Emitter> emitters, float strength) {
        BlockPos.MutableBlockPos potentialNode = origin.offset(Math.round((float)(spreadProvider.sample(random) * (random.nextBoolean() ? 1 : -1)) * (bias ? 0.667f : 1.0f)), 0, Math.round((float)(spreadProvider.sample(random) * (random.nextBoolean() ? 1 : -1)) * (!bias ? 0.667f : 1.0f))).mutable();
        if (world.getBlockState((BlockPos)potentialNode).isAir() && world.getBlockState(potentialNode.offset(0, -1, 0)).isAir() && !world.getBlockState(potentialNode.offset(0, -2, 0)).isAir()) {
            emitters.add(new Emitter(potentialNode.move(0, -1, 0), strength, cutout));
            return;
        }
        while (!world.getBlockState((BlockPos)potentialNode).isAir()) {
            potentialNode.move(0, 1, 0);
            if (world.getBlockState((BlockPos)potentialNode).isAir()) {
                emitters.add(new Emitter(potentialNode, strength, cutout));
                break;
            }
            if (potentialNode.getY() - origin.getY() <= spreadProvider.getMaxValue() / 2) continue;
            break;
        }
    }

    private void placeAsh(WorldGenLevel world, BlockPos.MutableBlockPos pos, int height) {
        BlockState state = world.getBlockState((BlockPos)pos);
        if (state.is((Block)PastelBlocks.ASH_PILE.get())) {
            Integer layers = (Integer)state.getValue((Property)LAYERS);
            int layerDif = 8 - layers;
            if (height >= layerDif) {
                this.placeAshBlock(world, pos, 8);
                if ((height -= layerDif) == 0) {
                    return;
                }
            } else {
                this.placeAshBlock(world, pos, layers + height);
                return;
            }
            pos.move(Direction.UP);
        }
        if (height <= 8) {
            this.placeAshBlock(world, pos, height);
            return;
        }
        while (height > 0) {
            if (height > 8) {
                this.placeAshBlock(world, pos, 8);
                pos.move(Direction.UP);
                height -= 8;
                continue;
            }
            this.placeAshBlock(world, pos, height);
            height = 0;
        }
    }

    private void placeAshBlock(WorldGenLevel world, BlockPos.MutableBlockPos pos, int height) {
        if (height == 8) {
            this.setBlock((LevelWriter)world, (BlockPos)pos, ((Block)PastelBlocks.ASH.get()).defaultBlockState());
        } else {
            this.setBlock((LevelWriter)world, (BlockPos)pos, (BlockState)((Block)PastelBlocks.ASH_PILE.get()).defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(height)));
        }
    }

    private float getStrengthAt(BlockPos pos, BlockPos origin, List<Emitter> emitters, int originalY, float maxArea, float decay, float cutoutDecay) {
        float strength = 0.0f;
        for (Emitter emitter : emitters) {
            if (emitter.cutout) {
                float cutoutStrength = (float)Math.sqrt(pos.distSqr((Vec3i)emitter.pos));
                cutoutStrength *= -cutoutDecay;
                if (!((cutoutStrength += emitter.strength) > 0.0f)) continue;
                strength -= cutoutStrength;
                continue;
            }
            float emitterStrength = (float)Math.sqrt(pos.distSqr((Vec3i)emitter.pos));
            emitterStrength *= -decay;
            if (!((emitterStrength += emitter.strength) > 0.0f)) continue;
            strength += emitterStrength;
        }
        strength = (float)Mth.clampedLerp((double)strength, (double)0.0, (double)(Math.sqrt(pos.distSqr((Vec3i)origin)) / (double)maxArea));
        return strength;
    }

    private boolean adjustPlacementHeight(WorldGenLevel world, BlockPos.MutableBlockPos pos, int maxShifts) {
        boolean foundValidSpace = false;
        for (int shifts = 1; shifts < maxShifts + 1; ++shifts) {
            BlockPos upPos = pos.offset(0, shifts, 0);
            if (AshDunesFeature.canPlaceAt(world, upPos) || world.getBlockState((BlockPos)pos).is((Block)PastelBlocks.ASH_PILE.get())) {
                pos.move(0, shifts, 0);
                foundValidSpace = true;
                break;
            }
            BlockPos downPos = pos.offset(0, -shifts, 0);
            if (!AshDunesFeature.canPlaceAt(world, downPos) && !world.getBlockState((BlockPos)pos).is((Block)PastelBlocks.ASH_PILE.get())) continue;
            pos.move(0, -shifts, 0);
            foundValidSpace = true;
            break;
        }
        return foundValidSpace;
    }

    private static boolean canPlaceAt(WorldGenLevel world, BlockPos pos) {
        return (world.isEmptyBlock(pos) || world.getBlockState(pos).is((Block)PastelBlocks.VARIA_SPROUT.get())) && ((Block)PastelBlocks.ASH_PILE.get()).defaultBlockState().canSurvive((LevelReader)world, pos);
    }

    private record Emitter(BlockPos.MutableBlockPos pos, float strength, boolean cutout) {
    }
}

