/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.worldgen.features.CrystalFormationFeatureFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class CrystalFormationFeature
extends Feature<CrystalFormationFeatureFeatureConfig> {
    public CrystalFormationFeature(Codec<CrystalFormationFeatureFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<CrystalFormationFeatureFeatureConfig> context) {
        WorldGenLevel structureWorldAccess = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        if (!structureWorldAccess.isEmptyBlock(blockPos)) {
            return false;
        }
        CrystalFormationFeatureFeatureConfig config = (CrystalFormationFeatureFeatureConfig)context.config();
        boolean upwards = false;
        if (config.canGrowUpwards().booleanValue() && structureWorldAccess.getBlockState(blockPos.below()).is(config.canStartOnBlocks())) {
            upwards = true;
        } else if (!config.canGrowDownwards().booleanValue() || !structureWorldAccess.getBlockState(blockPos.above()).is(config.canStartOnBlocks())) {
            return false;
        }
        BlockStateProvider stateProvider = config.blockStateProvider();
        int iterations = config.iterationCountProvider().sample(random);
        structureWorldAccess.setBlock(blockPos, stateProvider.getState(random, blockPos), 2);
        for (int i = 0; i < iterations; ++i) {
            BlockPos offsetPos = blockPos.offset(random.nextInt(8) - random.nextInt(8), upwards ? random.nextInt(12) : -random.nextInt(12), random.nextInt(8) - random.nextInt(8));
            if (!structureWorldAccess.getBlockState(offsetPos).isAir()) continue;
            int directionTries = 0;
            for (Direction direction : Direction.values()) {
                if (structureWorldAccess.getBlockState(offsetPos.relative(direction)).is(config.canExtendOnBlocks())) {
                    ++directionTries;
                }
                if (directionTries > 1) break;
            }
            if (directionTries != true) continue;
            structureWorldAccess.setBlock(offsetPos, stateProvider.getState(random, blockPos), 2);
        }
        return true;
    }
}

