/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.worldgen.features.GilledFungusFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class GiantGilledFungusFeature
extends Feature<GilledFungusFeatureConfig> {
    public GiantGilledFungusFeature(Codec<GilledFungusFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<GilledFungusFeatureConfig> context) {
        int stemHeight;
        WorldGenLevel world = context.level();
        BlockPos blockPos = context.origin();
        GilledFungusFeatureConfig config = (GilledFungusFeatureConfig)context.config();
        Block validBaseBlock = config.validBase();
        BlockState baseBlock = world.getBlockState(blockPos.below());
        if (!baseBlock.is(validBaseBlock)) {
            return false;
        }
        RandomSource random = context.random();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        int maxHeight = config.baseStemHeight().sample(random);
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        int stemGirth = 1;
        for (stemHeight = 0; stemHeight < maxHeight && GiantGilledFungusFeature.isReplaceable((LevelAccessor)world, (BlockPos)mutable.move(Direction.UP), false); ++stemHeight) {
        }
        if ((float)stemHeight < (float)maxHeight / 1.667f) {
            return false;
        }
        stemGirth += (int)Math.floor((float)stemHeight / 33.0f);
        if (blockPos.getY() + stemHeight + 1 >= chunkGenerator.getGenDepth()) {
            return false;
        }
        world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 4);
        this.generateStemRing(blockPos.below(3), config, (LevelAccessor)world, random, stemGirth, stemHeight + 3, true);
        if (stemHeight > 60 || stemHeight > 30 && random.nextBoolean()) {
            this.generateHat((LevelAccessor)world, random, config, blockPos, stemHeight, 1.0f);
            this.generateHat((LevelAccessor)world, random, config, blockPos, Math.round((float)stemHeight * 0.65f), 0.7f);
        } else {
            this.generateHat((LevelAccessor)world, random, config, blockPos, stemHeight, 1.0f);
        }
        int i = 0;
        while ((float)i < (float)stemHeight / 1.5f) {
            this.generateHat((LevelAccessor)world, random, config, blockPos.offset(random.nextInt(stemGirth * 3), 0, random.nextInt(stemGirth * 3)), random.nextInt(stemHeight / 5) + 1, random.nextFloat() / (float)(i + 1) * 0.5f + 0.5f);
            ++i;
        }
        return true;
    }

    private static boolean isReplaceable(LevelAccessor world, BlockPos pos, boolean replacePlants) {
        return world.isStateAtPosition(pos, state -> state.canBeReplaced() || replacePlants);
    }

    private void generateStemRing(BlockPos blockPos, GilledFungusFeatureConfig config, LevelAccessor world, RandomSource random, int stemGirth, int stemHeight, boolean recursive) {
        BlockPos.MutableBlockPos stemPos = blockPos.mutable();
        for (int x = -stemGirth; x <= stemGirth; ++x) {
            for (int z = -stemGirth; z <= stemGirth; ++z) {
                stemPos.setWithOffset((Vec3i)blockPos, x, 0, z);
                if (Math.sqrt(stemPos.distSqr((Vec3i)blockPos)) > (double)stemGirth) continue;
                this.generateStem(world, config, (BlockPos)stemPos, stemHeight);
                if (!recursive || stemPos.equals((Object)blockPos) || !(random.nextFloat() <= 0.2f)) continue;
                int height = Math.round((float)stemHeight * (random.nextFloat() * 0.667f));
                int offsetX = (int)((float)x * (2.0f + random.nextFloat()));
                int offsetZ = (int)((float)z * (2.0f + random.nextFloat()));
                this.generateStemRing(stemPos.offset(offsetX, 0, offsetZ), config, world, random, stemGirth / 2, height, false);
                this.generateHat(world, random, config, stemPos.offset((int)((double)offsetX * 1.5), 0, (int)((double)offsetZ * 1.5)), height, 0.333f + random.nextFloat() * 0.667f);
            }
        }
    }

    private void generateStem(LevelAccessor world, GilledFungusFeatureConfig config, BlockPos pos, int stemHeight) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockState blockState = config.stem().defaultBlockState();
        int i = 0;
        for (int x = -i; x <= i; ++x) {
            for (int z = -i; z <= i; ++z) {
                for (int y = 0; y < stemHeight; ++y) {
                    mutable.setWithOffset((Vec3i)pos, x, y, z);
                    if (!GiantGilledFungusFeature.isReplaceable(world, (BlockPos)mutable, true)) continue;
                    this.setBlock((LevelWriter)world, (BlockPos)mutable, blockState);
                }
            }
        }
    }

    private void generateHat(LevelAccessor world, RandomSource random, GilledFungusFeatureConfig config, BlockPos pos, int stemHeight, float sizeMod) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int hatRadius = Math.round(Math.min((float)Math.round((float)random.nextInt(Math.round(1.0f + (float)stemHeight / 7.0f)) + (float)stemHeight / 7.0f + 3.0f) * sizeMod, 17.0f));
        BlockState gillsState = config.gills().defaultBlockState();
        BlockState capState = config.cap().defaultBlockState();
        int start = hatRadius > 11 ? -3 : -2;
        boolean firstLoop = true;
        for (int y = start; y < Math.max(Math.round((float)hatRadius / 3.0f), 2); ++y) {
            boolean isLowestLevel;
            boolean underHang = y < 0;
            boolean bl = isLowestLevel = y == 0;
            int currentRadius = underHang ? hatRadius : (int)Math.round((double)hatRadius / Math.pow(1.175, Math.max(y - 1, 0))) - (isLowestLevel ? 0 : 1);
            for (int x = -currentRadius; x <= currentRadius; ++x) {
                for (int z = -currentRadius; z <= currentRadius; ++z) {
                    boolean isCorner;
                    boolean bl2 = isCorner = Math.abs(x) == currentRadius && Math.abs(z) == currentRadius;
                    if (isCorner) continue;
                    mutable.setWithOffset((Vec3i)pos, x, stemHeight + y, z);
                    if (!GiantGilledFungusFeature.isReplaceable(world, (BlockPos)mutable, false)) continue;
                    double rad = Math.sqrt(mutable.distToCenterSqr((double)pos.getX(), (double)mutable.getY(), (double)pos.getZ()));
                    if (underHang) {
                        if (random.nextInt(3) == 0 && firstLoop || !(rad <= (double)currentRadius) || !(rad > (double)(currentRadius - 1))) continue;
                        this.setBlock((LevelWriter)world, (BlockPos)mutable, capState);
                        continue;
                    }
                    if (isLowestLevel) {
                        if (rad <= (double)((float)currentRadius / 1.5f) && rad >= (double)((float)currentRadius / 3.0f)) continue;
                        if (rad <= (double)(currentRadius - 1)) {
                            this.setBlock((LevelWriter)world, (BlockPos)mutable, (BlockState)gillsState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)(Math.abs(x) < Math.abs(z) ? Direction.Axis.X : Direction.Axis.Z)));
                            continue;
                        }
                        if (!(rad <= (double)currentRadius)) continue;
                        this.setBlock((LevelWriter)world, (BlockPos)mutable, capState);
                        continue;
                    }
                    if (!(rad <= (double)currentRadius)) continue;
                    this.setBlock((LevelWriter)world, (BlockPos)mutable, capState);
                }
            }
            firstLoop = false;
        }
    }
}

