/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.worldgen.features.GilledFungusFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class GilledFungusFeature
extends Feature<GilledFungusFeatureConfig> {
    public GilledFungusFeature(Codec<GilledFungusFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<GilledFungusFeatureConfig> context) {
        WorldGenLevel structureWorldAccess = context.level();
        BlockPos blockPos = context.origin();
        GilledFungusFeatureConfig hugeFungusFeatureConfig = (GilledFungusFeatureConfig)context.config();
        Block validBaseBlock = hugeFungusFeatureConfig.validBase();
        BlockState baseBlock = structureWorldAccess.getBlockState(blockPos.below());
        if (!baseBlock.is(validBaseBlock)) {
            return false;
        }
        RandomSource random = context.random();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        int stemHeight = hugeFungusFeatureConfig.baseStemHeight().sample(random);
        if (random.nextInt(12) == 0) {
            stemHeight *= 2;
        }
        if (blockPos.getY() + stemHeight + 1 >= chunkGenerator.getGenDepth()) {
            return false;
        }
        structureWorldAccess.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 4);
        this.generateStem((LevelAccessor)structureWorldAccess, hugeFungusFeatureConfig, blockPos, stemHeight);
        this.generateHat((LevelAccessor)structureWorldAccess, random, hugeFungusFeatureConfig, blockPos, stemHeight);
        return true;
    }

    private static boolean isReplaceable(LevelAccessor world, BlockPos pos, boolean replacePlants) {
        return world.isStateAtPosition(pos, state -> state.canBeReplaced() || replacePlants);
    }

    private void generateStem(LevelAccessor world, GilledFungusFeatureConfig config, BlockPos pos, int stemHeight) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockState blockState = config.stem().defaultBlockState();
        int i = 0;
        for (int x = -i; x <= i; ++x) {
            for (int z = -i; z <= i; ++z) {
                for (int y = 0; y < stemHeight; ++y) {
                    mutable.setWithOffset((Vec3i)pos, x, y, z);
                    if (!GilledFungusFeature.isReplaceable(world, (BlockPos)mutable, true)) continue;
                    this.setBlock((LevelWriter)world, (BlockPos)mutable, blockState);
                }
            }
        }
    }

    private void generateHat(LevelAccessor world, RandomSource random, GilledFungusFeatureConfig config, BlockPos pos, int stemHeight) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int hatRadius = Math.min(random.nextInt(1 + stemHeight / 5) + 4, 9);
        BlockState gillsState = config.gills().defaultBlockState();
        BlockState capState = config.cap().defaultBlockState();
        int start = hatRadius > 4 ? -2 : -1;
        boolean firstLoop = true;
        for (int y = start; y < Math.max(Math.round((float)hatRadius / 3.0f), 2); ++y) {
            boolean isLowestLevel;
            boolean underHang = y < 0;
            boolean bl = isLowestLevel = y == 0;
            int currentRadius = underHang ? hatRadius : (int)Math.round((double)hatRadius / Math.pow(1.175, Math.max(y - 1, 0))) - (isLowestLevel ? 0 : 1);
            for (int x = -currentRadius; x <= currentRadius; ++x) {
                for (int z = -currentRadius; z <= currentRadius; ++z) {
                    boolean isCorner;
                    boolean bl2 = isCorner = Math.abs(x) == currentRadius && Math.abs(z) == currentRadius;
                    if (isCorner) continue;
                    mutable.setWithOffset((Vec3i)pos, x, stemHeight + y, z);
                    if (!GilledFungusFeature.isReplaceable(world, (BlockPos)mutable, false)) continue;
                    double rad = Math.sqrt(mutable.distToCenterSqr((double)pos.getX(), (double)mutable.getY(), (double)pos.getZ()));
                    if (underHang) {
                        if (random.nextInt(3) == 0 && firstLoop || !(rad <= (double)currentRadius) || !(rad > (double)(currentRadius - 1))) continue;
                        this.setBlock((LevelWriter)world, (BlockPos)mutable, capState);
                        continue;
                    }
                    if (isLowestLevel) {
                        if (rad <= (double)(currentRadius - 1)) {
                            this.setBlock((LevelWriter)world, (BlockPos)mutable, (BlockState)gillsState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)(Math.abs(x) < Math.abs(z) ? Direction.Axis.X : Direction.Axis.Z)));
                            continue;
                        }
                        if (!(rad <= (double)currentRadius)) continue;
                        this.setBlock((LevelWriter)world, (BlockPos)mutable, capState);
                        continue;
                    }
                    if (!(rad <= (double)currentRadius)) continue;
                    this.setBlock((LevelWriter)world, (BlockPos)mutable, capState);
                }
            }
            firstLoop = false;
        }
    }
}

