/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.worldgen.features.RandomBudsFeaturesConfig;
import java.util.Iterator;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class RandomBudsFeature
extends Feature<RandomBudsFeaturesConfig> {
    public RandomBudsFeature(Codec<RandomBudsFeaturesConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<RandomBudsFeaturesConfig> context) {
        WorldGenLevel structureWorldAccess = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        RandomBudsFeaturesConfig randomBudsFeaturesConfig = (RandomBudsFeaturesConfig)context.config();
        int placedCount = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int j = randomBudsFeaturesConfig.xzSpread + 1;
        int k = randomBudsFeaturesConfig.ySpread + 1;
        for (int l = 0; l < randomBudsFeaturesConfig.tries; ++l) {
            mutable.setWithOffset((Vec3i)blockPos, random.nextInt(j) - random.nextInt(j), random.nextInt(k) - random.nextInt(k), random.nextInt(j) - random.nextInt(j));
            List<Direction> directions = RandomBudsFeature.shuffleDirections(randomBudsFeaturesConfig, random);
            BlockState state = structureWorldAccess.getBlockState((BlockPos)mutable);
            boolean waterlogged = false;
            if (state.is(Blocks.WATER)) {
                waterlogged = true;
            } else if (!state.isAir()) continue;
            if (!RandomBudsFeature.generate(structureWorldAccess, (BlockPos)mutable, randomBudsFeaturesConfig, random, directions, waterlogged)) continue;
            ++placedCount;
        }
        return placedCount > 0;
    }

    public static boolean generate(WorldGenLevel world, BlockPos pos, RandomBudsFeaturesConfig config, RandomSource random, List<Direction> directions, boolean waterlogged) {
        Direction direction;
        BlockState blockState;
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        Iterator<Direction> directionIterator = directions.iterator();
        do {
            if (directionIterator.hasNext()) continue;
            return false;
        } while (!(blockState = world.getBlockState((BlockPos)mutablePos.setWithOffset((Vec3i)pos, direction = directionIterator.next()))).is(config.canPlaceOn));
        BlockState stateToPlace = (BlockState)((BlockState)config.blocks.get(random.nextInt(config.blocks.size())).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        if (stateToPlace.canSurvive((LevelReader)world, pos)) {
            world.setBlock(pos, stateToPlace, 3);
            world.getChunk(pos).markPosForPostprocessing(pos);
            return true;
        }
        return false;
    }

    public static List<Direction> shuffleDirections(RandomBudsFeaturesConfig config, RandomSource random) {
        return Util.toShuffledList(config.directions.stream(), (RandomSource)random);
    }
}

