/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class RandomBudsFeaturesConfig
implements FeatureConfiguration {
    public static final Codec<RandomBudsFeaturesConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)64).fieldOf("xz_spread").orElse((Object)10).forGetter(config -> config.xzSpread), (App)Codec.intRange((int)1, (int)64).fieldOf("y_spread").orElse((Object)10).forGetter(config -> config.ySpread), (App)Codec.intRange((int)1, (int)64).fieldOf("tries").orElse((Object)12).forGetter(config -> config.tries), (App)Codec.BOOL.fieldOf("can_place_on_floor").orElse((Object)false).forGetter(config -> config.placeOnFloor), (App)Codec.BOOL.fieldOf("can_place_on_ceiling").orElse((Object)false).forGetter(config -> config.placeOnCeiling), (App)Codec.BOOL.fieldOf("can_place_on_wall").orElse((Object)false).forGetter(config -> config.placeOnWalls), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("can_be_placed_on").forGetter(config -> config.canPlaceOn), (App)ExtraCodecs.nonEmptyList((Codec)BuiltInRegistries.BLOCK.byNameCodec().listOf()).fieldOf("blocks").forGetter(config -> config.blocks)).apply((Applicative)instance, RandomBudsFeaturesConfig::new));
    public final int xzSpread;
    public final int ySpread;
    public final int tries;
    public final boolean placeOnFloor;
    public final boolean placeOnCeiling;
    public final boolean placeOnWalls;
    public final HolderSet<Block> canPlaceOn;
    public final List<Direction> directions;
    public final List<Block> blocks;

    public RandomBudsFeaturesConfig(Integer xzSpread, Integer ySpread, Integer tries, Boolean placeOnFloor, Boolean placeOnCeiling, Boolean placeOnWalls, HolderSet<Block> canPlaceOn, List<Block> blocks) {
        this.xzSpread = xzSpread;
        this.ySpread = ySpread;
        this.tries = tries;
        this.placeOnFloor = placeOnFloor;
        this.placeOnCeiling = placeOnCeiling;
        this.placeOnWalls = placeOnWalls;
        this.canPlaceOn = canPlaceOn;
        this.blocks = blocks;
        ArrayList list = Lists.newArrayList();
        if (placeOnCeiling.booleanValue()) {
            list.add(Direction.UP);
        }
        if (placeOnFloor.booleanValue()) {
            list.add(Direction.DOWN);
        }
        if (placeOnWalls.booleanValue()) {
            Objects.requireNonNull(list);
            Direction.Plane.HORIZONTAL.forEach(list::add);
        }
        this.directions = Collections.unmodifiableList(list);
    }
}

