/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.registries.PastelStructureTypes;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class UndergroundJigsawStructure
extends Structure {
    public static final MapCodec<UndergroundJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UndergroundJigsawStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("bury_depth").forGetter(structure -> structure.buryDepth), (App)Codec.intRange((int)0, (int)64).fieldOf("placement_check_width").forGetter(structure -> structure.placementCheckWidth), (App)Codec.intRange((int)0, (int)64).fieldOf("placement_check_height").forGetter(structure -> structure.placementCheckHeight), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, UndergroundJigsawStructure::new));
    protected final Holder<StructureTemplatePool> startPool;
    protected final Optional<ResourceLocation> startJigsawName;
    protected final int size;
    protected final int placementCheckWidth;
    protected final int placementCheckHeight;
    protected final HeightProvider startHeight;
    protected final IntProvider buryDepth;
    protected final int maxDistanceFromCenter;

    public UndergroundJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, Integer size, HeightProvider startHeight, IntProvider buryDepth, Integer placementCheckWidth, Integer placementCheckHeight, Integer maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.buryDepth = buryDepth;
        this.placementCheckWidth = placementCheckWidth;
        this.placementCheckHeight = placementCheckHeight;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        BoundingBox structureBox;
        RandomState noiseConfig;
        LevelHeightAccessor world;
        WorldgenRandom chunkRandom = context.random();
        WorldGenerationContext heightContext = new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor());
        int x = context.chunkPos().getMinBlockX() + chunkRandom.nextInt(16);
        int z = context.chunkPos().getMinBlockZ() + chunkRandom.nextInt(16);
        int y = this.startHeight.sample((RandomSource)chunkRandom, heightContext);
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        Optional<Integer> floorHeight = UndergroundJigsawStructure.getFloorHeight((RandomSource)chunkRandom, chunkGenerator, world = context.heightAccessor(), noiseConfig = context.randomState(), structureBox = BoundingBox.fromCorners((Vec3i)new BlockPos(x - this.placementCheckWidth / 2, y, z - this.placementCheckWidth / 2), (Vec3i)new BlockPos(x + this.placementCheckWidth / 2, y + this.placementCheckHeight, z + this.placementCheckWidth / 2)), this.buryDepth);
        if (floorHeight.isEmpty()) {
            return Optional.empty();
        }
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)new BlockPos(x, floorHeight.get().intValue(), z), (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)JigsawStructure.DEFAULT_DIMENSION_PADDING, (LiquidSettings)JigsawStructure.DEFAULT_LIQUID_SETTINGS);
    }

    public StructureType<UndergroundJigsawStructure> type() {
        return PastelStructureTypes.UNDERGROUND_JIGSAW;
    }

    private static Optional<Integer> getFloorHeight(RandomSource random, ChunkGenerator chunkGenerator, LevelHeightAccessor world, RandomState noiseConfig, BoundingBox box, IntProvider buryDepth) {
        int lowestY = world.getMinBuildHeight() + 12;
        int floorY = box.minY();
        int structureHeight = box.maxY() - box.minY();
        if (floorY > chunkGenerator.getBaseHeight(box.minX(), box.minZ(), Heightmap.Types.OCEAN_FLOOR_WG, world, noiseConfig) - structureHeight || floorY > chunkGenerator.getBaseHeight(box.minX(), box.maxZ(), Heightmap.Types.OCEAN_FLOOR_WG, world, noiseConfig) - structureHeight || floorY > chunkGenerator.getBaseHeight(box.maxZ(), box.minZ(), Heightmap.Types.OCEAN_FLOOR_WG, world, noiseConfig) - structureHeight || floorY > chunkGenerator.getBaseHeight(box.maxZ(), box.maxZ(), Heightmap.Types.OCEAN_FLOOR_WG, world, noiseConfig) - structureHeight) {
            return Optional.empty();
        }
        NoiseColumn heightLimitView = chunkGenerator.getBaseColumn(box.getCenter().getX(), box.getCenter().getZ(), world, noiseConfig);
        while (true) {
            if (floorY < lowestY) {
                return Optional.empty();
            }
            if (!heightLimitView.getBlock(floorY).isSolid()) break;
            --floorY;
        }
        NoiseColumn[] verticalBlockSamples = new NoiseColumn[]{chunkGenerator.getBaseColumn(box.minX(), box.minZ(), world, noiseConfig), chunkGenerator.getBaseColumn(box.minX(), box.maxZ(), world, noiseConfig), chunkGenerator.getBaseColumn(box.maxX(), box.minZ(), world, noiseConfig), chunkGenerator.getBaseColumn(box.maxX(), box.maxZ(), world, noiseConfig)};
        Predicate blockPredicate = Heightmap.Types.OCEAN_FLOOR_WG.isOpaque();
        while (floorY >= lowestY) {
            int matchingBlocks = 0;
            for (NoiseColumn verticalBlockSample : verticalBlockSamples) {
                BlockState blockState = verticalBlockSample.getBlock(floorY);
                if (!blockPredicate.test(blockState) || ++matchingBlocks != 3) continue;
                if ((floorY -= buryDepth.sample(random)) < lowestY) {
                    return Optional.empty();
                }
                return Optional.of(floorY);
            }
            --floorY;
        }
        return Optional.empty();
    }
}

