/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.modules.trail.misc;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.octostudios.perception.common.modules.trail.config.data.TrailConfigData;
import it.hurts.octostudios.perception.common.modules.trail.misc.wrapper.ArrowTrailWrapper;
import it.hurts.octostudios.perception.common.modules.trail.misc.wrapper.ExperienceOrbTrailWrapper;
import it.hurts.octostudios.perception.common.modules.trail.misc.wrapper.FireworkRocketTrailWrapper;
import it.hurts.octostudios.perception.common.modules.trail.misc.wrapper.ThrownPotionTrailWrapper;
import it.hurts.octostudios.perception.common.modules.trail.misc.wrapper.base.TrailWrapper;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;

public final class TrailProviderFactory {
    public static EntityTrailProvider<?> create(Entity entity, TrailConfigData data) {
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class, ExperienceOrb.class, ThrownPotion.class, FireworkRocketEntity.class}, (Object)entity3, n)) {
            case 0 -> {
                Arrow arrow = (Arrow)entity3;
                yield new ArrowTrailWrapper(arrow, data);
            }
            case 1 -> {
                ExperienceOrb orb = (ExperienceOrb)entity3;
                yield new ExperienceOrbTrailWrapper(orb, data);
            }
            case 2 -> {
                ThrownPotion potion = (ThrownPotion)entity3;
                yield new ThrownPotionTrailWrapper(potion, data);
            }
            case 3 -> {
                FireworkRocketEntity rocket = (FireworkRocketEntity)entity3;
                yield new FireworkRocketTrailWrapper(rocket, data);
            }
            default -> new TrailWrapper<Entity>(entity, data);
        };
    }
}

