/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.modules.trail.misc.wrapper;

import it.hurts.octostudios.perception.common.modules.trail.config.data.TrailConfigData;
import it.hurts.octostudios.perception.common.modules.trail.misc.wrapper.base.TrailWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.component.FireworkExplosion;

public class FireworkRocketTrailWrapper
extends TrailWrapper<FireworkRocketEntity> {
    public FireworkRocketTrailWrapper(FireworkRocketEntity entity, TrailConfigData data) {
        super(entity, data);
    }

    @Override
    public int getTrailFadeInColor() {
        List explosions = ((FireworkRocketEntity)this.entity).getExplosions();
        int maxSize = explosions.size();
        if (maxSize == 0) {
            return -1;
        }
        ArrayList colors = new ArrayList();
        for (FireworkExplosion explosion : explosions) {
            colors.addAll(explosion.colors());
        }
        int count = colors.size();
        if (count < 2) {
            return colors.isEmpty() ? -1 : (Integer)colors.getFirst() & 0xFFFFFF | 0xFF000000;
        }
        int totalTime = count * 3;
        int tick = ((FireworkRocketEntity)this.entity).tickCount % totalTime;
        float t = (float)tick / (float)totalTime * (float)colors.size();
        int index = (int)Math.floor(t) % colors.size();
        float fraction = t - (float)((int)t);
        Integer color1 = (Integer)colors.get(index);
        Integer color2 = (Integer)colors.get((index + 1) % colors.size());
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * fraction);
        int g = (int)((float)g1 + (float)(g2 - g1) * fraction);
        int b = (int)((float)b1 + (float)(b2 - b1) * fraction);
        return r << 16 | g << 8 | b | 0xFF000000;
    }
}

