/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.modules.trail.misc.wrapper.base;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.octostudios.perception.common.modules.trail.config.data.TrailConfigData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class TrailWrapper<T extends Entity>
extends EntityTrailProvider<T> {
    private TrailConfigData data;

    public TrailWrapper(T entity, TrailConfigData data) {
        super(entity);
        this.data = data;
    }

    public int getTrailMaxLength() {
        return this.data.getMaxPoints();
    }

    public int getTrailUpdateFrequency() {
        return this.data.getUpdateFrequency();
    }

    public double getTrailScale() {
        return this.data.getSize();
    }

    public Vec3 getTrailPosition(float partialTicks) {
        Vector3f offset = this.data.getPositionOffset();
        Vec3 entityPosition = (this.entity.tickCount > 1 ? this.entity.getPosition(partialTicks) : this.entity.position()).add(this.entity.getDeltaMovement().normalize().scale((double)(-this.data.getMotionShift()))).add((double)offset.x(), (double)offset.y(), (double)offset.z());
        Player player = this.entity.getCommandSenderWorld().getNearestPlayer(this.entity, this.getTrailRenderDistance());
        if (player == null) {
            return entityPosition;
        }
        Vec3 playerPosition = player.getEyePosition(partialTicks);
        entityPosition = entityPosition.add(entityPosition.subtract(playerPosition).normalize().scale((double)this.data.getBackwardShift()));
        return entityPosition;
    }

    public boolean isTrailGrowing() {
        return this.entity.getKnownMovement().length() >= (double)this.data.getMinSpeed();
    }

    public boolean isTrailAlive() {
        return this.entity.isAlive();
    }

    public int getTrailFadeInColor() {
        return (int)Long.parseLong(this.data.getFadeInColor().replace("#", ""), 16);
    }

    public int getTrailFadeOutColor() {
        return (int)Long.parseLong(this.data.getFadeOutColor().replace("#", ""), 16);
    }

    public TrailConfigData getData() {
        return this.data;
    }

    public void setData(TrailConfigData data) {
        this.data = data;
    }
}

