/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.commands;

import com.google.gson.JsonElement;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.util.data.RuntimeDatagenHelpers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.LootCommand;
import net.minecraft.world.level.storage.loot.LootTable;

public class SerializeLootTableCommand {
    public static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(arg -> Component.translatable((String)"placebo.cmd.not_found", (Object[])new Object[]{arg}));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"serialize_loot_table").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"loot_table", (ArgumentType)ResourceLocationArgument.id()).suggests(LootCommand.SUGGEST_LOOT_TABLE).executes(ctx -> {
            ResourceLocation id = ResourceLocationArgument.getId((CommandContext)ctx, (String)"loot_table");
            RegistryAccess.Frozen access = ((CommandSourceStack)ctx.getSource()).getServer().reloadableRegistries().get();
            LootTable table = (LootTable)access.registryOrThrow(Registries.LOOT_TABLE).get(id);
            if (table == LootTable.EMPTY) {
                throw NOT_FOUND.create((Object)id);
            }
            RuntimeDatagenHelpers.write((JsonElement)LootTable.DIRECT_CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)access), (Object)table).getOrThrow(), "loot_table", id);
            String path = "datagen/" + id.getNamespace() + "/loot_table/" + id.getPath() + ".json";
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"placebo.cmd.serialize_success", (Object[])new Object[]{id.toString(), path}), true);
            return 0;
        })));
    }
}

