/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.ender;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import owmii.powah.lib.block.IOwnable;
import owmii.powah.lib.logistics.energy.Energy;

public class EnderNetwork
extends SavedData {
    private static final String NAME = "powah_network";
    public static final int MAX_CHANNELS = 12;
    private static final SavedData.Factory<EnderNetwork> DATA_FACTORY = new SavedData.Factory(EnderNetwork::new, EnderNetwork::new, null);
    private final Map<UUID, ImmutableList<Energy>> map = new HashMap<UUID, ImmutableList<Energy>>();

    public static EnderNetwork get(ServerLevel level) {
        return EnderNetwork.get(level.getServer());
    }

    public static EnderNetwork get(MinecraftServer server) {
        ServerLevel overworld = server.getLevel(ServerLevel.OVERWORLD);
        Objects.requireNonNull(overworld, "Server should have an overworld.");
        return (EnderNetwork)overworld.getDataStorage().computeIfAbsent(DATA_FACTORY, NAME);
    }

    private EnderNetwork() {
    }

    private EnderNetwork(CompoundTag nbt, HolderLookup.Provider registries) {
        ListTag listNBT = nbt.getList("network", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundTag nbt1 = listNBT.getCompound(i);
            UUID uuid = nbt1.getUUID("owner_id");
            ListTag listNBT1 = nbt1.getList("channels", 10);
            for (int j = 0; j < listNBT1.size(); ++j) {
                CompoundTag nbt2 = listNBT1.getCompound(j);
                this.getEnergy(uuid, j).read(nbt2, true, false);
            }
        }
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        ListTag listNBT = new ListTag();
        this.map.forEach((uuid, list) -> {
            CompoundTag nbt1 = new CompoundTag();
            nbt1.putUUID("owner_id", uuid);
            ListTag listNBT1 = new ListTag();
            list.forEach(storage -> {
                CompoundTag nbt2 = new CompoundTag();
                storage.write(nbt2, true, false);
                listNBT1.add((Object)nbt2);
            });
            nbt1.put("channels", (Tag)listNBT1);
            listNBT.add((Object)nbt1);
        });
        nbt.put("network", (Tag)listNBT);
        return nbt;
    }

    public CompoundTag serialize(UUID uuid) {
        CompoundTag nbt = new CompoundTag();
        nbt.put("channels", (Tag)this.getChannels(uuid).stream().map(energy -> energy.write(true, false)).collect(Collectors.toCollection(ListTag::new)));
        return nbt;
    }

    public void deserialize(UUID uuid, CompoundTag nbt) {
        ListTag listNBT = nbt.getList("channels", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            this.getEnergy(uuid, i).read(listNBT.getCompound(i), true, false);
        }
    }

    public Energy getEnergy(IOwnable ownable, int channel) {
        if (ownable.getOwner() != null) {
            return this.getEnergy(ownable.getOwner().getId(), channel);
        }
        return Energy.create(0L);
    }

    public Energy getEnergy(UUID uuid, int channel) {
        if (channel < 12) {
            return (Energy)this.getChannels(uuid).get(channel);
        }
        return Energy.create(0L);
    }

    public void setEnergy(UUID uuid, int channel, Energy energy) {
        this.getEnergy(uuid, channel).clone(energy);
        this.setDirty();
    }

    public ImmutableList<Energy> getChannels(IOwnable ownable) {
        if (ownable.getOwner() != null) {
            return this.getChannels(ownable.getOwner().getId());
        }
        return EnderNetwork.empty();
    }

    public ImmutableList<Energy> getChannels(UUID uuid) {
        return this.map.computeIfAbsent(uuid, k -> EnderNetwork.empty());
    }

    public static ImmutableList<Energy> empty() {
        return (ImmutableList)IntStream.range(0, 12).mapToObj(i -> Energy.create(0L)).collect(ImmutableList.toImmutableList());
    }
}

