/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.data;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import owmii.powah.compat.curios.CurioTagsProvider;
import owmii.powah.data.LootTableGenerator;
import owmii.powah.data.PowahDataMapProvider;
import owmii.powah.data.RecipeProvider;
import owmii.powah.data.TagsProvider;
import owmii.powah.world.gen.Features;

public class PowahDataGenerator {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        DataGenerator.PackGenerator pack = generator.getVanillaPack(true);
        CompletableFuture registries = event.getLookupProvider();
        TagsProvider.Blocks blockTagsProvider = (TagsProvider.Blocks)pack.addProvider(packOutput -> new TagsProvider.Blocks(packOutput, registries, existingFileHelper));
        pack.addProvider(packOutput -> new TagsProvider.Items(packOutput, registries, blockTagsProvider.contentsGetter(), existingFileHelper));
        pack.addProvider(packOutput -> new CurioTagsProvider(packOutput, registries, blockTagsProvider.contentsGetter(), event.getExistingFileHelper()));
        pack.addProvider(packOutput -> new RecipeProvider(packOutput, registries));
        pack.addProvider(packOutput -> PowahDataGenerator.createLoot(packOutput, registries));
        pack.addProvider(packOutput -> new PowahDataMapProvider(packOutput, registries));
        RegistrySetBuilder worldgenBuilder = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, Features::initConfiguredFeatures).add(Registries.PLACED_FEATURE, Features::initPlacedFeatures).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, Features::initBiomeModifiers);
        pack.addProvider(output -> new DatapackBuiltinEntriesProvider(output, registries, worldgenBuilder, Set.of("powah")));
    }

    public static LootTableProvider createLoot(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        return new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(LootTableGenerator::new, LootContextParamSets.BLOCK)), registries);
    }
}

