/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import owmii.powah.api.wrench.IWrench;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.CableTile;
import owmii.powah.block.energizing.EnergizingOrbBlock;
import owmii.powah.components.PowahComponents;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.client.handler.IHudItem;
import owmii.powah.lib.item.ItemBase;
import owmii.powah.lib.logistics.energy.SideConfig;

public class WrenchItem
extends ItemBase
implements IHudItem,
IWrench {
    private static final WrenchMode DEFAULT_WRENCH_MODE = WrenchMode.values()[0];
    private static final Direction[] DIRECTIONS = Direction.values();

    public WrenchItem(Item.Properties properties) {
        super(properties.component(PowahComponents.WRENCH_MODE, (Object)DEFAULT_WRENCH_MODE));
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, Level world, BlockPos pos, Player player, InteractionHand hand, Direction side, Vec3 hit) {
        BlockState rotatedState;
        IWrenchable iWrenchable;
        if (player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        BlockEntity te = world.getBlockEntity(pos);
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof IWrenchable && (iWrenchable = (IWrenchable)block).onWrench(state, world, pos, player, hand, side, this.getWrenchMode(stack), hit)) {
            return InteractionResult.SUCCESS;
        }
        if (!world.isClientSide && this.getWrenchMode(stack).config() && te instanceof CableTile) {
            CableTile cable = (CableTile)te;
            if (stack.getItem() instanceof WrenchItem) {
                Optional<Direction> sides = CableBlock.getHitSide(hit, pos);
                boolean[] flag = new boolean[]{false};
                sides.ifPresent(direction -> {
                    SideConfig config = cable.getSideConfig();
                    config.nextType((Direction)direction);
                    cable.sync();
                });
                return InteractionResult.SUCCESS;
            }
        }
        if (this.getWrenchMode(stack).rotate() && (state.getBlock() instanceof AbstractEnergyBlock || state.getBlock() instanceof EnergizingOrbBlock) && !state.equals(rotatedState = this.rotateState(world, state, pos))) {
            world.setBlockAndUpdate(pos, rotatedState);
            world.playSound(player, pos, rotatedState.getBlock().getSoundType(rotatedState, (LevelReader)world, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.onItemUseFirst(stack, world, pos, player, hand, side, hit);
    }

    private BlockState rotateState(Level world, BlockState state, BlockPos pos) {
        for (Property property : state.getProperties()) {
            if (!property.getName().equals("facing") || !(property instanceof DirectionProperty)) continue;
            DirectionProperty dirProp = (DirectionProperty)property;
            Direction current = (Direction)state.getValue((Property)dirProp);
            Direction rotated = WrenchItem.nextDirection(current);
            while (!property.getPossibleValues().contains(rotated) || !((BlockState)state.setValue((Property)dirProp, (Comparable)rotated)).canSurvive((LevelReader)world, pos)) {
                if ((rotated = WrenchItem.nextDirection(rotated)) != current) continue;
                return state;
            }
            return (BlockState)state.setValue((Property)dirProp, (Comparable)rotated);
        }
        return state;
    }

    private static Direction nextDirection(Direction dir) {
        return DIRECTIONS[(dir.ordinal() + 1) % DIRECTIONS.length];
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown()) {
            this.nextWrenchMode(stack);
            playerIn.displayClientMessage((Component)Component.translatable((String)"info.powah.wrench.mode", (Object[])new Object[]{Component.translatable((String)("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase())).withStyle(ChatFormatting.YELLOW)}), true);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"info.powah.wrench.mode", (Object[])new Object[]{Component.translatable((String)("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase())).withStyle(ChatFormatting.YELLOW)}));
    }

    @Override
    public boolean renderHud(Level world, BlockPos pos, Player player, InteractionHand hand, Direction side, Vec3 hit) {
        return false;
    }

    private boolean changeWrenchMode(ItemStack stack, boolean next) {
        if (stack.getItem() instanceof IWrench) {
            if (next) {
                this.nextWrenchMode(stack);
                return true;
            }
            this.prevWrenchMode(stack);
            return true;
        }
        return false;
    }

    private void nextWrenchMode(ItemStack stack) {
        WrenchMode mode = this.getWrenchMode(stack);
        mode = WrenchMode.BY_ID.apply(mode.ordinal() + 1);
        stack.set(PowahComponents.WRENCH_MODE, (Object)mode);
    }

    private void prevWrenchMode(ItemStack stack) {
        WrenchMode mode = this.getWrenchMode(stack);
        mode = WrenchMode.BY_ID.apply(mode.ordinal() - 1);
        stack.set(PowahComponents.WRENCH_MODE, (Object)mode);
    }

    @Override
    public WrenchMode getWrenchMode(ItemStack stack) {
        return Objects.requireNonNullElse((WrenchMode)((Object)stack.get(PowahComponents.WRENCH_MODE)), DEFAULT_WRENCH_MODE);
    }
}

