/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.prism.util;

import net.minecraft.util.Mth;
import org.apache.commons.lang3.math.NumberUtils;

public class ColorUtil {
    private static int round(float value) {
        return (int)(value * 255.0f + 0.5f);
    }

    public static int combineARGB(int a, int r, int g, int b) {
        a = Mth.clamp((int)a, (int)0, (int)255);
        r = Mth.clamp((int)r, (int)0, (int)255);
        g = Mth.clamp((int)g, (int)0, (int)255);
        b = Mth.clamp((int)b, (int)0, (int)255);
        return a << 24 | r << 16 | g << 8 | b << 0;
    }

    public static int combineRGB(int r, int g, int b) {
        return ColorUtil.combineARGB(255, r, g, b);
    }

    public static int HSVtoRGB(int hue, int saturation, int value) {
        return ColorUtil.AHSVtoARGB(255, hue, saturation, value);
    }

    public static int HSVtoRGB(float hue, float saturation, float value) {
        return ColorUtil.AHSVtoARGB(1.0f, hue, saturation, value);
    }

    public static int AHSVtoARGB(int alpha, int hue, int saturation, int value) {
        return ColorUtil.AHSVtoARGB((float)alpha / 255.0f, (float)hue / 360.0f, (float)saturation / 255.0f, (float)value / 255.0f);
    }

    public static int AHSVtoARGB(float alpha, float hue, float saturation, float value) {
        alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        hue = Mth.clamp((float)hue, (float)0.0f, (float)1.0f);
        saturation = Mth.clamp((float)saturation, (float)0.0f, (float)1.0f);
        value = Mth.clamp((float)value, (float)0.0f, (float)1.0f);
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = ColorUtil.round(value);
            r = b;
        } else {
            int h = (int)(hue * 6.0f);
            float ff = hue * 6.0f - (float)h;
            float p = value * (1.0f - saturation);
            float q = value * (1.0f - saturation * ff);
            float t = value * (1.0f - saturation * (1.0f - ff));
            switch (h) {
                case 0: {
                    r = ColorUtil.round(value);
                    g = ColorUtil.round(t);
                    b = ColorUtil.round(p);
                    break;
                }
                case 1: {
                    r = ColorUtil.round(q);
                    g = ColorUtil.round(value);
                    b = ColorUtil.round(p);
                    break;
                }
                case 2: {
                    r = ColorUtil.round(p);
                    g = ColorUtil.round(value);
                    b = ColorUtil.round(t);
                    break;
                }
                case 3: {
                    r = ColorUtil.round(p);
                    g = ColorUtil.round(q);
                    b = ColorUtil.round(value);
                    break;
                }
                case 4: {
                    r = ColorUtil.round(t);
                    g = ColorUtil.round(p);
                    b = ColorUtil.round(value);
                    break;
                }
                case 5: {
                    r = ColorUtil.round(value);
                    g = ColorUtil.round(p);
                    b = ColorUtil.round(q);
                }
            }
        }
        return ColorUtil.combineARGB(ColorUtil.round(alpha), r, g, b);
    }

    public static float[] RGBtoHSV(float r, float g, float b) {
        float[] result = ColorUtil.ARGBtoAHSV(1.0f, r, g, b);
        return new float[]{result[1], result[2], result[3]};
    }

    public static float[] RGBtoHSV(int r, int g, int b) {
        float[] result = ColorUtil.ARGBtoAHSV(255, r, g, b);
        return new float[]{result[1], result[2], result[3]};
    }

    public static float[] ARGBtoAHSV(float a, float r, float g, float b) {
        return ColorUtil.ARGBtoAHSV(ColorUtil.round(a), ColorUtil.round(r), ColorUtil.round(g), ColorUtil.round(b));
    }

    public static float[] ARGBtoAHSV(int a, int r, int g, int b) {
        float hue;
        a = Mth.clamp((int)a, (int)0, (int)255);
        r = Mth.clamp((int)r, (int)0, (int)255);
        g = Mth.clamp((int)g, (int)0, (int)255);
        b = Mth.clamp((int)b, (int)0, (int)255);
        int cmax = NumberUtils.max((int)r, (int)g, (int)b);
        int cmin = NumberUtils.min((int)r, (int)g, (int)b);
        float value = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new float[]{a, hue, saturation, value};
    }
}

