/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import net.minecraft.util.Mth;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import vazkii.psi.client.core.handler.ClientTickHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.ItemExosuitSensor;
import vazkii.psi.common.item.armor.ItemPsimetalArmor;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.item.component.ItemCADColorizer;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="psi")
public class ColorHandler {
    @SubscribeEvent
    public static void init(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex == 1 ? ((ItemPsimetalArmor)stack.getItem()).getColor(stack) : -1, new ItemLike[]{ModItems.psimetalExosuitBoots, ModItems.psimetalExosuitChestplate, ModItems.psimetalExosuitHelmet, ModItems.psimetalExosuitLeggings});
        event.register((stack, tintIndex) -> tintIndex == 1 ? ((ItemExosuitSensor)stack.getItem()).getColor(stack) : -1, new ItemLike[]{ModItems.exosuitSensorHeat, ModItems.exosuitSensorLight, ModItems.exosuitSensorStress, ModItems.exosuitSensorWater, ModItems.exosuitSensorTrigger});
        event.register((stack, tintIndex) -> tintIndex == 1 ? ((ItemCAD)stack.getItem()).getSpellColor(stack) : -1, new ItemLike[]{ModItems.cad});
        event.register((stack, tintIndex) -> tintIndex != 1 ? -1 : ((ItemCADColorizer)stack.getItem()).getColor(stack), new ItemLike[]{ModItems.cadColorizerWhite, ModItems.cadColorizerOrange, ModItems.cadColorizerMagenta, ModItems.cadColorizerLightBlue, ModItems.cadColorizerYellow, ModItems.cadColorizerLime, ModItems.cadColorizerPink, ModItems.cadColorizerGray, ModItems.cadColorizerLightGray, ModItems.cadColorizerCyan, ModItems.cadColorizerPurple, ModItems.cadColorizerBlue, ModItems.cadColorizerBrown, ModItems.cadColorizerGreen, ModItems.cadColorizerRed, ModItems.cadColorizerBlack});
    }

    public static int slideColor(int[] color, float speed) {
        int n = color.length;
        double t = (double)(ClientTickHandler.total * speed * (float)n) / Math.PI % (double)n;
        int phase = (int)t;
        double dt = t - (double)phase;
        if (dt == 0.0) {
            return color[phase];
        }
        int nextPhase = (phase + 1) % n;
        return ColorHandler.slideColorTime(color[phase], color[nextPhase], (float)(dt * Math.PI));
    }

    public static int pulseColor(int source, float speed, int magnitude) {
        return ColorHandler.pulseColor(source, 1.0f, speed, magnitude);
    }

    public static int pulseColor(int source, float multiplier, float speed, int magnitude) {
        int add = (int)(Mth.sin((float)((float)ClientTickHandler.ticksInGame * speed)) * (float)magnitude);
        int red = (0xFF0000 & source) >> 16;
        int green = (0xFF00 & source) >> 8;
        int blue = 0xFF & source;
        int addedRed = Mth.clamp((int)((int)(multiplier * (float)(red + add))), (int)0, (int)255);
        int addedGreen = Mth.clamp((int)((int)(multiplier * (float)(green + add))), (int)0, (int)255);
        int addedBlue = Mth.clamp((int)((int)(multiplier * (float)(blue + add))), (int)0, (int)255);
        return 0xFF000000 | addedRed << 16 | addedGreen << 8 | addedBlue;
    }

    public static int slideColorTime(int color, int secondColor, float t) {
        float shift = (1.0f - Mth.cos((float)t)) / 2.0f;
        if (shift == 0.0f) {
            return color;
        }
        if (shift == 1.0f) {
            return secondColor;
        }
        int redA = (0xFF0000 & color) >> 16;
        int greenA = (0xFF00 & color) >> 8;
        int blueA = 0xFF & color;
        int redB = (0xFF0000 & secondColor) >> 16;
        int greenB = (0xFF00 & secondColor) >> 8;
        int blueB = 0xFF & secondColor;
        int newRed = (int)((float)redA * (1.0f - shift) + (float)redB * shift);
        int newGreen = (int)((float)greenA * (1.0f - shift) + (float)greenB * shift);
        int newBlue = (int)((float)blueA * (1.0f - shift) + (float)blueB * shift);
        return 0xFF000000 | newRed << 16 | newGreen << 8 | newBlue;
    }
}

