/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.render.entity;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.client.model.ArmorModels;
import vazkii.psi.common.Psi;
import vazkii.psi.common.entity.EntitySpellCircle;

public class RenderSpellCircle
extends EntityRenderer<EntitySpellCircle> {
    private static final RenderType[] LAYERS = new RenderType[3];
    private static final float BRIGHTNESS_FACTOR = 0.7f;

    public RenderSpellCircle(EntityRendererProvider.Context ctx) {
        super(ctx);
        ArmorModels.init(ctx);
    }

    public static void renderSpellCircle(float alive, float scale, float horizontalScale, float xDir, float yDir, float zDir, int color, PoseStack ms, MultiBufferSource buffers) {
        ms.pushPose();
        double ratio = 0.0625 * (double)horizontalScale;
        float mag = xDir * xDir + yDir * yDir + zDir * zDir;
        if ((zDir /= mag) == -1.0f) {
            ms.mulPose(Axis.XP.rotationDegrees(180.0f));
        } else if (zDir != 1.0f) {
            ms.mulPose(new Quaternionf().rotateAxis((float)(Math.acos(zDir) * 180.0 / Math.PI), -yDir / mag, xDir / mag, 0.0f));
        }
        ms.translate(0.0, 0.0, 0.1);
        ms.scale((float)ratio * scale, (float)ratio * scale, (float)ratio);
        int r = PsiRenderHelper.r(color);
        int g = PsiRenderHelper.g(color);
        int b = PsiRenderHelper.b(color);
        for (int i = 0; i < LAYERS.length; ++i) {
            int rValue = r;
            int gValue = g;
            int bValue = b;
            if (i == 1) {
                bValue = 255;
                gValue = 255;
                rValue = 255;
            } else if (i == 2) {
                int minBrightness = 3;
                if (rValue == 0 && gValue == 0 && bValue == 0) {
                    gValue = bValue = minBrightness;
                    rValue = bValue;
                }
                if (rValue > 0 && rValue < minBrightness) {
                    rValue = minBrightness;
                }
                if (gValue > 0 && gValue < minBrightness) {
                    gValue = minBrightness;
                }
                if (bValue > 0 && bValue < minBrightness) {
                    bValue = minBrightness;
                }
                rValue = (int)Math.min((float)rValue / 0.7f, 255.0f);
                gValue = (int)Math.min((float)gValue / 0.7f, 255.0f);
                bValue = (int)Math.min((float)bValue / 0.7f, 255.0f);
            }
            ms.pushPose();
            ms.mulPose(Axis.ZP.rotationDegrees(i == 0 ? -alive : alive));
            VertexConsumer buffer = buffers.getBuffer(LAYERS[i]);
            Matrix4f mat = ms.last().pose();
            int fullbright = 0xF000F0;
            buffer.addVertex(mat, -32.0f, 32.0f, 0.0f).setColor(rValue, gValue, bValue, 255).setUv(0.0f, 1.0f).setLight(fullbright);
            buffer.addVertex(mat, 32.0f, 32.0f, 0.0f).setColor(rValue, gValue, bValue, 255).setUv(1.0f, 1.0f).setLight(fullbright);
            buffer.addVertex(mat, 32.0f, -32.0f, 0.0f).setColor(rValue, gValue, bValue, 255).setUv(1.0f, 0.0f).setLight(fullbright);
            buffer.addVertex(mat, -32.0f, -32.0f, 0.0f).setColor(rValue, gValue, bValue, 255).setUv(0.0f, 0.0f).setLight(fullbright);
            ms.popPose();
            ms.translate(0.0, 0.0, -0.5);
        }
        ms.popPose();
    }

    public void render(EntitySpellCircle entity, float entityYaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light) {
        ms.pushPose();
        ItemStack colorizer = (ItemStack)entity.getEntityData().get(EntitySpellCircle.COLORIZER_DATA);
        int color = Psi.proxy.getColorForColorizer(colorizer);
        float alive = (float)entity.getTimeAlive() + partialTicks;
        float scale = Math.min(1.0f, alive / 5.0f);
        if (alive > 105.0f) {
            scale = 1.0f - Math.min(1.0f, Math.max(0.0f, alive - 105.0f) / 5.0f);
        }
        RenderSpellCircle.renderSpellCircle(alive, scale, 1.0f, 0.0f, 1.0f, 0.0f, color, ms, buffers);
        ms.popPose();
    }

    public ResourceLocation getTextureLocation(EntitySpellCircle entitySpellCircle) {
        return null;
    }

    static {
        for (int i = 0; i < LAYERS.length; ++i) {
            ResourceLocation texture = ResourceLocation.parse((String)String.format("psi:textures/misc/spell_circle%d.png", i));
            RenderType.CompositeState glState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setCullState(new RenderStateShard.CullStateShard(false)).setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).setLightmapState(new RenderStateShard.LightmapStateShard(true)).createCompositeState(true);
            RenderSpellCircle.LAYERS[i] = RenderType.create((String)("psi:spell_circle_" + i), (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)64, (boolean)false, (boolean)false, (RenderType.CompositeState)glState);
        }
    }
}

