/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import vazkii.psi.client.core.handler.ClientTickHandler;
import vazkii.psi.client.gui.GuiProgrammer;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileProgrammer;

public class RenderTileProgrammer
implements BlockEntityRenderer<TileProgrammer> {
    public RenderTileProgrammer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(TileProgrammer te, float partialticks, PoseStack ms, MultiBufferSource buffers, int worldLight, int overlay) {
        if (te.isEnabled()) {
            ms.pushPose();
            int light = Psi.magical ? worldLight : 0xF000F0;
            ms.translate(0.0f, 1.62f, 0.0f);
            ms.mulPose(Axis.ZP.rotationDegrees(180.0f));
            ms.mulPose(Axis.YP.rotationDegrees(-90.0f));
            float rot = 90.0f;
            BlockState state = te.getBlockState();
            Direction facing = (Direction)state.getValue((Property)FaceAttachedHorizontalDirectionalBlock.FACING);
            switch (facing) {
                case SOUTH: {
                    rot = -90.0f;
                    break;
                }
                case EAST: {
                    rot = 180.0f;
                    break;
                }
                case WEST: {
                    rot = 0.0f;
                    break;
                }
            }
            ms.translate(0.5f, 0.0f, 0.5f);
            ms.mulPose(Axis.YP.rotationDegrees(rot));
            ms.translate(-0.5f, 0.0f, -0.5f);
            float f = 0.0033333334f;
            ms.scale(f, f, -f);
            if (Psi.magical) {
                ms.mulPose(Axis.XP.rotationDegrees(90.0f));
                ms.translate(70.0, -220.0, -100.0 + Math.sin(ClientTickHandler.total / 50.0f) * 10.0);
                ms.mulPose(Axis.XP.rotationDegrees(-16.0f + (float)Math.cos(ClientTickHandler.total / 100.0f) * 10.0f));
            } else {
                ms.translate(70.0f, 0.0f, -200.0f);
            }
            te.spell.draw(ms, buffers, light);
            ms.pushPose();
            ms.translate(0.0f, 0.0f, -0.01f);
            VertexConsumer buffer = buffers.getBuffer(GuiProgrammer.LAYER);
            float x = -7.0f;
            float y = -7.0f;
            float width = 174.0f;
            float height = 184.0f;
            float u = 0.0f;
            float v = 0.0f;
            float rescale = 0.00390625f;
            float a = Psi.magical ? 1.0f : 0.5f;
            Matrix4f mat = ms.last().pose();
            buffer.addVertex(mat, x, y + height, 0.0f).setColor(1.0f, 1.0f, 1.0f, a).setUv(u * rescale, (v + height) * rescale).setLight(light);
            buffer.addVertex(mat, x + width, y + height, 0.0f).setColor(1.0f, 1.0f, 1.0f, a).setUv((u + width) * rescale, (v + height) * rescale).setLight(light);
            buffer.addVertex(mat, x + width, y, 0.0f).setColor(1.0f, 1.0f, 1.0f, a).setUv((u + width) * rescale, v * rescale).setLight(light);
            buffer.addVertex(mat, x, y, 0.0f).setColor(1.0f, 1.0f, 1.0f, a).setUv(u * rescale, v * rescale).setLight(light);
            ms.popPose();
            int color = Psi.magical ? 0 : 0xFFFFFF;
            Minecraft mc = Minecraft.getInstance();
            mc.font.drawInBatch(I18n.get((String)"psimisc.name", (Object[])new Object[0]), 0.0f, 164.0f, color, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            mc.font.drawInBatch(te.spell.name, 38.0f, 164.0f, color, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            ms.popPose();
        }
    }
}

