/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile.container;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.inventory.InventorySocketable;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.block.tile.TileCADAssembler;
import vazkii.psi.common.block.tile.container.slot.InventoryAssemblerOutput;
import vazkii.psi.common.block.tile.container.slot.SlotCADOutput;
import vazkii.psi.common.block.tile.container.slot.SlotSocketable;
import vazkii.psi.common.block.tile.container.slot.ValidatorSlot;

public class ContainerCADAssembler
extends AbstractContainerMenu {
    private static final EquipmentSlot[] equipmentSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public final TileCADAssembler assembler;
    private final int cadComponentStart;
    private final int socketableStart;
    private final int socketableEnd;
    private final int bulletStart;
    private final int bulletEnd;
    private final int playerStart;
    private final int playerEnd;
    private final int hotbarStart;
    private final int hotbarEnd;
    private final int armorStart;

    public ContainerCADAssembler(int windowId, Inventory playerInventory, TileCADAssembler assembler) {
        super(ModBlocks.containerCADAssembler, windowId);
        final Player player = playerInventory.player;
        int playerSize = playerInventory.getContainerSize();
        this.assembler = assembler;
        IItemHandlerModifiable assemblerInv = assembler.getInventory();
        assembler.clearCachedCAD();
        InventoryAssemblerOutput output = new InventoryAssemblerOutput(player, assembler);
        InventorySocketable bullets = new InventorySocketable(assembler, assembler.getSocketableStack());
        this.addSlot(new SlotCADOutput(output, assembler, 120, 35));
        this.cadComponentStart = this.slots.size();
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)assemblerInv, EnumCADComponent.ASSEMBLY.ordinal() + 1, 120, 91));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)assemblerInv, EnumCADComponent.CORE.ordinal() + 1, 100, 91));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)assemblerInv, EnumCADComponent.SOCKET.ordinal() + 1, 140, 91));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)assemblerInv, EnumCADComponent.BATTERY.ordinal() + 1, 110, 111));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)assemblerInv, EnumCADComponent.DYE.ordinal() + 1, 130, 111));
        this.socketableStart = this.slots.size();
        this.addSlot((Slot)new SlotSocketable(assemblerInv, bullets, 0, 35, 21));
        this.socketableEnd = this.slots.size();
        this.bulletStart = this.slots.size();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.addSlot(new ValidatorSlot(bullets, col + row * 3, 17 + col * 18, 57 + row * 18));
            }
        }
        this.bulletEnd = this.slots.size();
        int xs = 48;
        int ys = 143;
        this.playerStart = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, xs + col * 18, ys + row * 18));
            }
        }
        this.playerEnd = this.slots.size();
        this.hotbarStart = this.slots.size();
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, xs + col * 18, ys + 58));
        }
        this.hotbarEnd = this.slots.size();
        this.armorStart = this.slots.size();
        for (int armorSlot = 0; armorSlot < 4; ++armorSlot) {
            final EquipmentSlot slot = equipmentSlots[armorSlot];
            this.addSlot(new Slot(this, (Container)playerInventory, playerSize - 2 - armorSlot, xs - 27, ys + 18 * armorSlot){

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(ItemStack stack) {
                    return !stack.isEmpty() && stack.getItem().canEquip(stack, slot, (LivingEntity)player);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)((ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(slot)));
                }
            });
        }
        this.addSlot(new Slot(this, (Container)playerInventory, playerSize - 1, 219, 143){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
    }

    public static ContainerCADAssembler fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        return new ContainerCADAssembler(windowId, playerInventory, (TileCADAssembler)playerInventory.player.level().getBlockEntity(pos));
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return !playerIn.isRemoved() && this.assembler.getBlockPos().distToCenterSqr((Position)playerIn.position()) <= 64.0;
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int from) {
        ItemStack mergeStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(from);
        if (slot != null && slot.hasItem()) {
            ArmorItem armor;
            int armorSlot;
            EnumCADComponent componentType;
            int componentSlot;
            ItemStack stackInSlot = slot.getItem();
            mergeStack = stackInSlot.copy();
            if (from >= this.playerStart ? (stackInSlot.getItem() instanceof ICADComponent ? !this.moveItemStackTo(stackInSlot, componentSlot = this.cadComponentStart + (componentType = ((ICADComponent)stackInSlot.getItem()).getComponentType(stackInSlot)).ordinal(), componentSlot + 1, false) : (ISocketable.isSocketable(stackInSlot) ? !this.moveItemStackTo(stackInSlot, this.socketableStart, this.socketableEnd, false) : (ISpellAcceptor.isContainer(stackInSlot) ? !this.moveItemStackTo(stackInSlot, this.bulletStart, this.bulletEnd, false) : (from < this.hotbarStart ? !this.moveItemStackTo(stackInSlot, this.hotbarStart, this.hotbarEnd, true) : !this.moveItemStackTo(stackInSlot, this.playerStart, this.playerEnd, false))))) : ((componentType = stackInSlot.getItem()) instanceof ArmorItem ? !this.moveItemStackTo(stackInSlot, armorSlot = this.armorStart + (armor = (ArmorItem)componentType).getType().ordinal() - 1, armorSlot + 1, true) && !this.moveItemStackTo(stackInSlot, this.playerStart, this.hotbarEnd, true) : !this.moveItemStackTo(stackInSlot, this.playerStart, this.hotbarEnd, true))) {
                return ItemStack.EMPTY;
            }
            slot.setChanged();
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else if (stackInSlot.getCount() == mergeStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stackInSlot);
        }
        return mergeStack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.assembler.clearCachedCAD();
    }
}

