/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile.container.slot;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.api.cad.CADTakeEvent;
import vazkii.psi.common.block.tile.TileCADAssembler;
import vazkii.psi.common.core.handler.PsiSoundHandler;

public class SlotCADOutput
extends Slot {
    private final TileCADAssembler assembler;

    public SlotCADOutput(Container outputInventory, TileCADAssembler assembler, int xPosition, int yPosition) {
        super(outputInventory, 0, xPosition, yPosition);
        this.assembler = assembler;
    }

    @NotNull
    public void onTake(Player playerIn, @NotNull ItemStack stack) {
        super.onTake(playerIn, stack);
        this.assembler.onCraftCAD(stack);
    }

    public boolean mayPickup(Player playerIn) {
        CADTakeEvent event = new CADTakeEvent(this.getItem(), this.assembler, playerIn);
        float sound = event.getSound();
        if (((CADTakeEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            BlockPos assemblerPos = this.assembler.getBlockPos();
            String cancelMessage = event.getCancellationMessage();
            if (!playerIn.level().isClientSide) {
                if (cancelMessage != null && !cancelMessage.isEmpty()) {
                    playerIn.sendSystemMessage((Component)Component.translatable((String)cancelMessage).setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                }
                playerIn.level().playSound(null, (double)assemblerPos.getX(), (double)assemblerPos.getY(), (double)assemblerPos.getZ(), PsiSoundHandler.compileError, SoundSource.BLOCKS, sound, 1.0f);
            }
            return false;
        }
        return super.mayPickup(playerIn);
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }
}

