/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageAdditiveMotion;

@EventBusSubscriber(modid="psi")
public class AdditiveMotionHandler {
    private static final Map<Entity, Vec3> toUpdate = new WeakHashMap<Entity, Vec3>();

    public static void addMotion(Entity entity, double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return;
        }
        if (!entity.level().isClientSide) {
            Vec3 base = toUpdate.getOrDefault(entity, Vec3.ZERO);
            toUpdate.put(entity, base.add(x, y, z));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(LevelTickEvent.Post e) {
        if (!e.getLevel().isClientSide()) {
            for (Entity entity : toUpdate.keySet()) {
                Vec3 vec;
                if (entity.hurtMarked || (vec = toUpdate.get(entity)) == null) continue;
                MessageAdditiveMotion motion = new MessageAdditiveMotion(entity.getId(), vec.x, vec.y, vec.z);
                if (entity instanceof ServerPlayer) {
                    MessageRegister.sendToPlayer((ServerPlayer)entity, motion);
                    ((ServerPlayer)entity).connection.aboveGroundTickCount = -80;
                } else {
                    entity.push(vec.x, vec.y, vec.z);
                }
                if (!(entity.level() instanceof ServerLevel)) continue;
                MessageRegister.sendToPlayersTrackingEntity(entity, motion);
            }
            toUpdate.clear();
        }
    }
}

