/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageLoopcastSync;

@EventBusSubscriber(modid="psi")
public class LoopcastTrackingHandler {
    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof Player) {
            LoopcastTrackingHandler.syncDataFor((Player)event.getTarget(), (ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.getEntity(), (ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.getEntity(), (ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.getEntity(), (ServerPlayer)event.getEntity());
    }

    public static void syncDataFor(Player player, ServerPlayer receiver) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        MessageRegister.sendToPlayer(receiver, new MessageLoopcastSync(player.getId(), data.loopcasting, data.loopcastHand));
    }

    public static void syncForTrackers(ServerPlayer player) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)player);
        MessageRegister.sendToPlayersTrackingEntity((Entity)player, new MessageLoopcastSync(player.getId(), data.loopcasting, data.loopcastHand));
    }

    public static void syncForTrackersAndSelf(ServerPlayer playerEntity) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)playerEntity);
        MessageLoopcastSync messageLoopcastSync = new MessageLoopcastSync(playerEntity.getId(), data.loopcasting, data.loopcastHand);
        MessageRegister.sendToPlayersTrackingEntity((Entity)playerEntity, messageLoopcastSync);
        MessageRegister.sendToPlayer(playerEntity, messageLoopcastSync);
    }
}

