/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.common.Psi;

public class EntitySpellCircle
extends Entity
implements ISpellImmune {
    public static final int CAST_TIMES = 20;
    public static final int CAST_DELAY = 5;
    public static final int LIVE_TIME = 110;
    public static final EntityDataAccessor<ItemStack> COLORIZER_DATA = SynchedEntityData.defineId(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final String TAG_COLORIZER = "colorizer";
    private static final String TAG_BULLET = "bullet";
    private static final String TAG_CASTER = "caster";
    private static final String TAG_TIME_ALIVE = "timeAlive";
    private static final String TAG_TIMES_CAST = "timesCast";
    private static final String TAG_LOOK_X = "savedLookX";
    private static final String TAG_LOOK_Y = "savedLookY";
    private static final String TAG_LOOK_Z = "savedLookZ";
    private static final EntityDataAccessor<ItemStack> BULLET_DATA = SynchedEntityData.defineId(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.defineId(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> TIME_ALIVE = SynchedEntityData.defineId(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TIMES_CAST = SynchedEntityData.defineId(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> LOOK_X = SynchedEntityData.defineId(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> LOOK_Y = SynchedEntityData.defineId(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> LOOK_Z = SynchedEntityData.defineId(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public EntitySpellCircle(EntityType<?> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntitySpellCircle setInfo(Player player, ItemStack colorizer, ItemStack bullet) {
        this.entityData.set(COLORIZER_DATA, (Object)colorizer);
        this.entityData.set(BULLET_DATA, (Object)bullet.copy());
        this.entityData.set(CASTER_UUID, Optional.of(player.getUUID()));
        Vec3 lookVec = player.getViewVector(1.0f);
        this.entityData.set(LOOK_X, (Object)Float.valueOf((float)lookVec.x));
        this.entityData.set(LOOK_Y, (Object)Float.valueOf((float)lookVec.y));
        this.entityData.set(LOOK_Z, (Object)Float.valueOf((float)lookVec.z));
        return this;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(COLORIZER_DATA, (Object)ItemStack.EMPTY);
        pBuilder.define(BULLET_DATA, (Object)ItemStack.EMPTY);
        pBuilder.define(CASTER_UUID, Optional.empty());
        pBuilder.define(TIME_ALIVE, (Object)0);
        pBuilder.define(TIMES_CAST, (Object)0);
        pBuilder.define(LOOK_X, (Object)Float.valueOf(0.0f));
        pBuilder.define(LOOK_Y, (Object)Float.valueOf(0.0f));
        pBuilder.define(LOOK_Z, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tagCompound) {
        CompoundTag colorizerCmp = new CompoundTag();
        ItemStack colorizer = (ItemStack)this.entityData.get(COLORIZER_DATA);
        if (!colorizer.isEmpty()) {
            colorizerCmp = colorizer.save((HolderLookup.Provider)this.registryAccess(), (Tag)colorizerCmp);
        }
        tagCompound.put(TAG_COLORIZER, (Tag)colorizerCmp);
        CompoundTag bulletCmp = new CompoundTag();
        ItemStack bullet = (ItemStack)this.entityData.get(BULLET_DATA);
        if (!bullet.isEmpty()) {
            bulletCmp = bullet.save((HolderLookup.Provider)this.registryAccess(), (Tag)bulletCmp);
        }
        tagCompound.put(TAG_BULLET, (Tag)bulletCmp);
        ((Optional)this.entityData.get(CASTER_UUID)).ifPresent(u -> tagCompound.putString(TAG_CASTER, u.toString()));
        tagCompound.putInt(TAG_TIME_ALIVE, this.getTimeAlive());
        tagCompound.putInt(TAG_TIMES_CAST, ((Integer)this.entityData.get(TIMES_CAST)).intValue());
        tagCompound.putFloat(TAG_LOOK_X, ((Float)this.entityData.get(LOOK_X)).floatValue());
        tagCompound.putFloat(TAG_LOOK_Y, ((Float)this.entityData.get(LOOK_Y)).floatValue());
        tagCompound.putFloat(TAG_LOOK_Z, ((Float)this.entityData.get(LOOK_Z)).floatValue());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tagCompound) {
        CompoundTag colorizerCmp = tagCompound.getCompound(TAG_COLORIZER);
        ItemStack colorizer = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)colorizerCmp);
        this.entityData.set(COLORIZER_DATA, (Object)colorizer);
        CompoundTag bulletCmp = tagCompound.getCompound(TAG_BULLET);
        ItemStack bullet = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)bulletCmp);
        this.entityData.set(BULLET_DATA, (Object)bullet);
        if (tagCompound.contains(TAG_CASTER)) {
            this.entityData.set(CASTER_UUID, Optional.of(UUID.fromString(tagCompound.getString(TAG_CASTER))));
        }
        this.setTimeAlive(tagCompound.getInt(TAG_TIME_ALIVE));
        this.entityData.set(TIMES_CAST, (Object)tagCompound.getInt(TAG_TIMES_CAST));
        this.entityData.set(LOOK_X, (Object)Float.valueOf(tagCompound.getFloat(TAG_LOOK_X)));
        this.entityData.set(LOOK_Y, (Object)Float.valueOf(tagCompound.getFloat(TAG_LOOK_Y)));
        this.entityData.set(LOOK_Z, (Object)Float.valueOf(tagCompound.getFloat(TAG_LOOK_Z)));
    }

    public void tick() {
        super.tick();
        int timeAlive = this.getTimeAlive();
        if (timeAlive > 110) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.setTimeAlive(timeAlive + 1);
        int times = (Integer)this.entityData.get(TIMES_CAST);
        if (timeAlive > 5 && timeAlive % 5 == 0 && times < 20) {
            ItemStack spellContainer;
            SpellContext context = null;
            LivingEntity thrower = this.getCaster();
            if (thrower instanceof Player && !(spellContainer = (ItemStack)this.entityData.get(BULLET_DATA)).isEmpty() && ISpellAcceptor.isContainer(spellContainer)) {
                this.entityData.set(TIMES_CAST, (Object)(times + 1));
                Spell spell = ISpellAcceptor.acceptor(spellContainer).getSpell();
                if (spell != null) {
                    context = new SpellContext().setPlayer((Player)thrower).setFocalPoint(this).setSpell(spell).setLoopcastIndex(times);
                }
            }
            if (context != null) {
                context.cspell.safeExecute(context);
            }
        }
        if (this.level().isClientSide) {
            ItemStack colorizer = (ItemStack)this.entityData.get(COLORIZER_DATA);
            int colorVal = Psi.proxy.getColorForColorizer(colorizer);
            float r = (float)PsiRenderHelper.r(colorVal) / 255.0f;
            float g = (float)PsiRenderHelper.g(colorVal) / 255.0f;
            float b = (float)PsiRenderHelper.b(colorVal) / 255.0f;
            for (int i = 0; i < 5; ++i) {
                double x = this.getX() + (Math.random() - 0.5) * (double)this.getBbWidth();
                double y = this.getY();
                double z = this.getZ() + (Math.random() - 0.5) * (double)this.getBbWidth();
                float grav = -0.15f - (float)Math.random() * 0.03f;
                Psi.proxy.sparkleFX(x, y, z, r, g, b, grav, 0.25f, 15);
            }
        }
    }

    public Vec3 getLookAngle() {
        float x = ((Float)this.entityData.get(LOOK_X)).floatValue();
        float y = ((Float)this.entityData.get(LOOK_Y)).floatValue();
        float z = ((Float)this.entityData.get(LOOK_Z)).floatValue();
        return new Vec3((double)x, (double)y, (double)z);
    }

    public int getTimeAlive() {
        return (Integer)this.entityData.get(TIME_ALIVE);
    }

    public void setTimeAlive(int i) {
        this.entityData.set(TIME_ALIVE, (Object)i);
    }

    @Nullable
    public LivingEntity getCaster() {
        return ((Optional)this.entityData.get(CASTER_UUID)).map(arg_0 -> ((Level)this.getCommandSenderWorld()).getPlayerByUUID(arg_0)).orElse(null);
    }

    @Override
    public boolean isImmune() {
        return true;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }
}

