/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.CADStatEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADAssembly;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.recipe.ITrickRecipe;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.PieceGroupAdvancementComplete;
import vazkii.psi.api.spell.PreSpellCastEvent;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCastEvent;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.piece.PieceCraftingTrick;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.BlockProgrammer;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.ContributorSpellCircleHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.core.handler.capability.CADData;
import vazkii.psi.common.crafting.ModCraftingRecipes;
import vazkii.psi.common.item.base.ModDataComponents;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.lib.LibPieceGroups;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageVisualEffect;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class ItemCAD
extends Item
implements ICAD {
    private static final String TAG_TIME_LEGACY = "time";
    private static final String TAG_STORED_PSI_LEGACY = "storedPsi";
    private static final String TAG_X_LEGACY = "x";
    private static final String TAG_Y_LEGACY = "y";
    private static final String TAG_Z_LEGACY = "z";
    private static final Pattern VECTOR_PREFIX_PATTERN = Pattern.compile("^storedVector(\\d+)$");
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*])|(?:ComputerCraft)$");
    private String contributorName = "";

    public ItemCAD(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.RARE).component((DataComponentType)ModDataComponents.BULLETS.get(), (Object)ItemContainerContents.EMPTY).component(ModDataComponents.CAD_DATA, (Object)new CADData.Data(0, 0, Lists.newArrayList())));
    }

    public void verifyComponentsAfterLoad(ItemStack pStack) {
        if (pStack.has(DataComponents.CUSTOM_DATA)) {
            ISocketable sockets;
            CustomData patch = (CustomData)pStack.get(DataComponents.CUSTOM_DATA);
            CompoundTag compound = patch.copyTag();
            ICADData data = (ICADData)pStack.getCapability(PsiAPI.CAD_DATA_CAPABILITY);
            if (data != null) {
                CompoundTag vec;
                if (compound.contains(TAG_TIME_LEGACY)) {
                    data.setTime(compound.getInt(TAG_TIME_LEGACY));
                    compound.remove(TAG_TIME_LEGACY);
                }
                if (compound.contains(TAG_STORED_PSI_LEGACY)) {
                    data.setBattery(compound.getInt(TAG_STORED_PSI_LEGACY));
                    compound.remove(TAG_STORED_PSI_LEGACY);
                }
                HashSet keys = new HashSet(compound.getAllKeys());
                for (String key : keys) {
                    Matcher matcher = VECTOR_PREFIX_PATTERN.matcher(key);
                    if (!matcher.find()) continue;
                    vec = compound.getCompound(key);
                    compound.remove(key);
                    int memory = Integer.parseInt(matcher.group(1));
                    Vector3 vector = new Vector3(vec.getDouble(TAG_X_LEGACY), vec.getDouble(TAG_Y_LEGACY), vec.getDouble(TAG_Z_LEGACY));
                    data.setSavedVector(memory, vector);
                }
                if (compound.contains("CapabilityData")) {
                    CompoundTag capability = compound.getCompound("CapabilityData");
                    compound.remove("CapabilityData");
                    if (capability.contains("Time")) {
                        data.setTime(capability.getInt("Time"));
                    }
                    if (capability.contains("Battery")) {
                        data.setBattery(capability.getInt("Battery"));
                    }
                    if (capability.contains("Memory")) {
                        ListTag memory = capability.getList("Memory", 9);
                        for (int i = 0; i < memory.size(); ++i) {
                            vec = (ListTag)memory.get(i);
                            if (vec.getElementType() == 6 && vec.size() >= 3) {
                                data.setSavedVector(i, new Vector3(vec.getDouble(0), vec.getDouble(1), vec.getDouble(2)));
                                continue;
                            }
                            data.setSavedVector(i, null);
                        }
                    }
                }
            }
            if ((sockets = this.getSocketable(pStack)) != null && Minecraft.getInstance().level != null) {
                for (EnumCADComponent components : EnumCADComponent.values()) {
                    if (!compound.contains("component" + components.name())) continue;
                    ItemStack component = ItemStack.parseOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)compound.getCompound("component" + components.name()));
                    component.applyComponents(DataComponentPatch.builder().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound.getCompound("component" + components.name()).getCompound("tag"))).build());
                    ItemCAD.setComponent(pStack, component);
                    compound.remove("component" + components.name());
                }
                for (int i = 0; i < 12; ++i) {
                    if (!compound.contains("bullet" + i)) continue;
                    ItemStack bullet = ItemStack.parseOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)compound.getCompound("bullet" + i));
                    bullet.applyComponents(DataComponentPatch.builder().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound.getCompound("bullet" + i).getCompound("tag"))).build());
                    sockets.setBulletInSocket(i, bullet);
                    compound.remove("bullet" + i);
                }
                if (compound.contains("selectedSlot")) {
                    sockets.setSelectedSlot(compound.getInt("selectedSlot"));
                    compound.remove("selectedSlot");
                }
            }
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)pStack, (CompoundTag)compound);
        }
    }

    public static Optional<ArrayList<Entity>> cast(Level world, Player player, PlayerDataHandler.PlayerData data, ItemStack bullet, ItemStack cad, int cd, int particles, float sound, Consumer<SpellContext> predicate) {
        return ItemCAD.cast(world, player, data, bullet, cad, cd, particles, sound, predicate, 0);
    }

    public static Optional<ArrayList<Entity>> cast(Level world, Player player, PlayerDataHandler.PlayerData data, ItemStack bullet, ItemStack cad, int cd, int particles, float sound, Consumer<SpellContext> predicate, int reservoir) {
        if (!data.overflowed && data.getAvailablePsi() > 0 && !cad.isEmpty() && !bullet.isEmpty() && ISpellAcceptor.hasSpell(bullet) && ItemCAD.isTruePlayer((Entity)player)) {
            ISpellAcceptor spellContainer = ISpellAcceptor.acceptor(bullet);
            Spell spell = spellContainer.getSpell();
            SpellContext context = new SpellContext().setPlayer(player).setSpell(spell);
            if (predicate != null) {
                predicate.accept(context);
            }
            if (context.isValid()) {
                if (context.cspell.metadata.evaluateAgainst(cad)) {
                    int cost = Math.max(ItemCAD.getRealCost(cad, bullet, context.cspell.metadata.getStat(EnumSpellStat.COST)) - reservoir, 0);
                    PreSpellCastEvent event = new PreSpellCastEvent(cost, sound, particles, cd, spell, context, player, data, cad, bullet);
                    if (((PreSpellCastEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                        String cancelMessage = event.getCancellationMessage();
                        if (cancelMessage != null && !cancelMessage.isEmpty()) {
                            player.sendSystemMessage((Component)Component.translatable((String)cancelMessage).setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                        }
                        return Optional.empty();
                    }
                    cd = event.getCooldown();
                    particles = event.getParticles();
                    sound = event.getSound();
                    cost = event.getCost();
                    spell = event.getSpell();
                    context = event.getContext();
                    if (cost > 0) {
                        data.deductPsi(cost, cd, true);
                    }
                    if (cost != 0 && sound > 0.0f) {
                        if (!world.isClientSide) {
                            world.playSound(null, player.getX(), player.getY(), player.getZ(), PsiSoundHandler.cadShoot, SoundSource.PLAYERS, sound, (float)(0.5 + Math.random() * 0.5));
                        } else {
                            int color = Psi.proxy.getColorForCAD(cad);
                            float r = (float)PsiRenderHelper.r(color) / 255.0f;
                            float g = (float)PsiRenderHelper.g(color) / 255.0f;
                            float b = (float)PsiRenderHelper.b(color) / 255.0f;
                            for (int i = 0; i < particles; ++i) {
                                double x = player.getX() + (Math.random() - 0.5) * 2.1 * (double)player.getBbWidth();
                                double y = player.getY() + 0.35;
                                double z = player.getZ() + (Math.random() - 0.5) * 2.1 * (double)player.getBbWidth();
                                float grav = -0.15f - (float)Math.random() * 0.03f;
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, grav, 0.25f, 15);
                            }
                            double x = player.getX();
                            double y = player.getY() + (double)player.getEyeHeight() - 0.1;
                            double z = player.getZ();
                            Vector3 lookOrig = new Vector3(player.getLookAngle());
                            for (int i = 0; i < 25; ++i) {
                                Vector3 look = lookOrig.copy();
                                double spread = 0.25;
                                look.x += (Math.random() - 0.5) * spread;
                                look.y += (Math.random() - 0.5) * spread;
                                look.z += (Math.random() - 0.5) * spread;
                                look.normalize().multiply(0.15);
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, (float)look.x, (float)look.y, (float)look.z, 0.3f, 5);
                            }
                        }
                    }
                    ArrayList<Object> SpellEntities = new ArrayList();
                    if (!world.isClientSide) {
                        SpellEntities = spellContainer.castSpell(context);
                    }
                    NeoForge.EVENT_BUS.post((Event)new SpellCastEvent(spell, context, player, data, cad, bullet));
                    return Optional.of(SpellEntities);
                }
                if (!world.isClientSide) {
                    player.sendSystemMessage((Component)Component.translatable((String)"psimisc.weak_cad").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                }
            }
        }
        return Optional.empty();
    }

    public static int getRealCost(ItemStack stack, ItemStack bullet, int cost) {
        if (!stack.isEmpty() && stack.getItem() instanceof ICAD) {
            int eff = ((ICAD)stack.getItem()).getStatValue(stack, EnumCADStat.EFFICIENCY);
            if (eff == -1) {
                return -1;
            }
            if (eff == 0) {
                return cost;
            }
            double effPercentile = (double)eff / 100.0;
            double procCost = (double)cost / effPercentile;
            if (!bullet.isEmpty() && ISpellAcceptor.isContainer(bullet)) {
                procCost *= ISpellAcceptor.acceptor(bullet).getCostModifier();
            }
            return (int)procCost;
        }
        return cost;
    }

    public static boolean isTruePlayer(Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        Player player = (Player)e;
        String name = player.getName().getString();
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    public static void setComponent(ItemStack stack, ItemStack componentStack) {
        if (stack.getItem() instanceof ICAD) {
            ((ICAD)stack.getItem()).setCADComponent(stack, componentStack);
        }
    }

    public static ItemStack makeCAD(ItemStack ... components) {
        return ItemCAD.makeCAD(Arrays.asList(components));
    }

    public static ItemStack makeCADWithAssembly(ItemStack assembly, List<ItemStack> components) {
        ItemStack cad = assembly.getItem() instanceof ICADAssembly ? ((ICADAssembly)assembly.getItem()).createCADStack(assembly, components) : new ItemStack((ItemLike)ModItems.cad);
        return ItemCAD.makeCAD(cad, components);
    }

    public static ItemStack makeCAD(List<ItemStack> components) {
        return ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cad), components);
    }

    public static ItemStack makeCAD(ItemStack base, List<ItemStack> components) {
        ItemStack stack = base.copy();
        for (ItemStack component : components) {
            ItemCAD.setComponent(stack, component);
        }
        return stack;
    }

    public static List<ItemStack> getCreativeTabItems() {
        ArrayList<ItemStack> subItems = new ArrayList<ItemStack>();
        subItems.add(ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyIron)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyIron), new ItemStack((ItemLike)ModItems.cadCoreBasic), new ItemStack((ItemLike)ModItems.cadSocketBasic), new ItemStack((ItemLike)ModItems.cadBatteryBasic)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyGold), new ItemStack((ItemLike)ModItems.cadCoreBasic), new ItemStack((ItemLike)ModItems.cadSocketBasic), new ItemStack((ItemLike)ModItems.cadBatteryBasic)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyPsimetal), new ItemStack((ItemLike)ModItems.cadCoreOverclocked), new ItemStack((ItemLike)ModItems.cadSocketSignaling), new ItemStack((ItemLike)ModItems.cadBatteryExtended)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyEbony), new ItemStack((ItemLike)ModItems.cadCoreHyperClocked), new ItemStack((ItemLike)ModItems.cadSocketTransmissive), new ItemStack((ItemLike)ModItems.cadBatteryUltradense)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyIvory), new ItemStack((ItemLike)ModItems.cadCoreHyperClocked), new ItemStack((ItemLike)ModItems.cadSocketTransmissive), new ItemStack((ItemLike)ModItems.cadBatteryUltradense)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyCreative), new ItemStack((ItemLike)ModItems.cadCoreHyperClocked), new ItemStack((ItemLike)ModItems.cadSocketTransmissive), new ItemStack((ItemLike)ModItems.cadBatteryUltradense)));
        return subItems;
    }

    private ICADData getCADData(ItemStack stack) {
        return Objects.requireNonNullElse((ICADData)stack.getCapability(PsiAPI.CAD_DATA_CAPABILITY), new CADData(stack));
    }

    private ISocketable getSocketable(ItemStack stack) {
        return Objects.requireNonNullElse((ISocketable)stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY), new CADData(stack));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!this.getComponentInSlot(stack, EnumCADComponent.DYE).isEmpty() && ContributorSpellCircleHandler.isContributor(entity.getName().getString().toLowerCase(Locale.ROOT)) && this.contributorName.equalsIgnoreCase(entity.getName().getString())) {
            this.contributorName = entity.getName().getString();
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level worldIn = ctx.getLevel();
        InteractionHand hand = ctx.getHand();
        BlockPos pos = ctx.getClickedPos();
        Player playerIn = ctx.getPlayer();
        ItemStack stack = playerIn.getItemInHand(hand);
        Block block = worldIn.getBlockState(pos).getBlock();
        return block == ModBlocks.programmer ? ((BlockProgrammer)block).setSpell(worldIn, pos, playerIn, stack) : InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, @NotNull InteractionHand hand) {
        ItemStack itemStackIn = playerIn.getItemInHand(hand);
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(playerIn);
        ItemStack playerCad = PsiAPI.getPlayerCAD(playerIn);
        if (playerCad != itemStackIn) {
            if (!worldIn.isClientSide) {
                playerIn.sendSystemMessage((Component)Component.translatable((String)"psimisc.multiple_cads").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
            }
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)itemStackIn);
        }
        ISocketable sockets = this.getSocketable(playerCad);
        ItemStack bullet = sockets.getSelectedBullet();
        boolean did = ItemCAD.cast(worldIn, playerIn, data, bullet, itemStackIn, 40, 25, 0.5f, ctx -> {
            ctx.castFrom = hand;
        }).isPresent();
        if (!data.overflowed && bullet.isEmpty() && this.craft(playerCad, playerIn, null)) {
            worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), PsiSoundHandler.cadShoot, SoundSource.PLAYERS, 0.5f, (float)(0.5 + Math.random() * 0.5));
            data.deductPsi(100, 60, true);
            if (!data.hasAdvancement(LibPieceGroups.FAKE_LEVEL_PSIDUST)) {
                NeoForge.EVENT_BUS.post((Event)new PieceGroupAdvancementComplete(null, playerIn, LibPieceGroups.FAKE_LEVEL_PSIDUST));
            }
            did = true;
        }
        return new InteractionResultHolder(did ? InteractionResult.CONSUME : InteractionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public boolean craft(ItemStack cad, Player player, PieceCraftingTrick craftingTrick) {
        Level world = player.level();
        if (world.isClientSide) {
            return false;
        }
        List items = player.getCommandSenderWorld().getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(8.0), entity -> entity != null && entity.distanceToSqr((Entity)player) <= 64.0);
        boolean did = false;
        for (ItemEntity item : items) {
            int count;
            int dropCount;
            ItemStack stack = item.getItem();
            SingleRecipeInput inv = new SingleRecipeInput(stack);
            Predicate<ITrickRecipe> predicate = craftingTrick != null ? r -> r.getPiece() == null || r.getPiece().canCraft(craftingTrick) : r -> r.getPiece() == null;
            Optional<RecipeHolder> recipe = world.getRecipeManager().getRecipeFor((RecipeType)ModCraftingRecipes.TRICK_RECIPE_TYPE.get(), (RecipeInput)inv, world).filter(r -> predicate.test((ITrickRecipe)r.value()));
            if (!recipe.isPresent()) continue;
            ItemStack outCopy = ((ITrickRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).copy();
            for (count = stack.getCount() * outCopy.getCount(); count > 64; count -= dropCount) {
                dropCount = world.getRandom().nextInt(32) + 32;
                ItemEntity drop = new ItemEntity(world, item.getX(), item.getY(), item.getZ(), new ItemStack((ItemLike)outCopy.getItem(), dropCount));
                Vec3 motion = item.getDeltaMovement();
                drop.setDeltaMovement(motion.x() + ((double)world.getRandom().nextFloat() - 0.5) / 5.0, motion.y() + (double)(world.getRandom().nextFloat() / 10.0f), motion.z() + ((double)world.getRandom().nextFloat() - 0.5) / 5.0);
                world.addFreshEntity((Entity)drop);
            }
            outCopy.setCount(count);
            item.setItem(outCopy);
            did = true;
            MessageVisualEffect msg = new MessageVisualEffect(-15481345, item.getX(), item.getY(), item.getZ(), item.getBbWidth(), item.getBbHeight(), 0.0, 0);
            MessageRegister.sendToPlayersTrackingEntityAndSelf((Entity)item, msg);
        }
        return did;
    }

    @Override
    public ItemStack getComponentInSlot(ItemStack stack, EnumCADComponent type) {
        List items = (List)stack.getOrDefault(ModDataComponents.COMPONENTS, new ArrayList<Item>(Collections.nCopies(EnumCADComponent.values().length, Items.AIR)));
        ItemStack component = new ItemStack((ItemLike)items.get(type.ordinal()));
        if (type == EnumCADComponent.DYE && !component.isEmpty() && !this.contributorName.isEmpty()) {
            ((ICADColorizer)items.get(type.ordinal())).setContributorName(component, this.contributorName);
        }
        return component;
    }

    @Override
    public int getStatValue(ItemStack stack, EnumCADStat stat) {
        Item item;
        int statValue = 0;
        ItemStack componentStack = this.getComponentInSlot(stack, stat.getSourceType());
        if (!componentStack.isEmpty() && (item = componentStack.getItem()) instanceof ICADComponent) {
            ICADComponent component = (ICADComponent)item;
            statValue = component.getCADStatValue(componentStack, stat);
        }
        CADStatEvent event = new CADStatEvent(stat, stack, componentStack, statValue);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getStatValue();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getSpellColor(ItemStack stack) {
        ItemStack dye = this.getComponentInSlot(stack, EnumCADComponent.DYE);
        if (!dye.isEmpty() && dye.getItem() instanceof ICADColorizer) {
            return ((ICADColorizer)dye.getItem()).getColor(dye);
        }
        return -15481345;
    }

    @Override
    public int getTime(ItemStack stack) {
        return this.getCADData(stack).getTime();
    }

    @Override
    public void incrementTime(ItemStack stack) {
        ICADData data = this.getCADData(stack);
        data.setTime(data.getTime() + 1);
    }

    @Override
    public int getStoredPsi(ItemStack stack) {
        int maxPsi = this.getStatValue(stack, EnumCADStat.OVERFLOW);
        return Math.min(this.getCADData(stack).getBattery(), maxPsi);
    }

    @Override
    public void regenPsi(ItemStack stack, int psi) {
        int maxPsi = this.getStatValue(stack, EnumCADStat.OVERFLOW);
        if (maxPsi == -1) {
            return;
        }
        int currPsi = this.getStoredPsi(stack);
        int endPsi = Math.min(currPsi + psi, maxPsi);
        if (endPsi != currPsi) {
            ICADData data = this.getCADData(stack);
            data.setBattery(endPsi);
        }
    }

    @Override
    public int consumePsi(ItemStack stack, int psi) {
        if (psi == 0) {
            return 0;
        }
        int currPsi = this.getStoredPsi(stack);
        if (currPsi == -1) {
            return 0;
        }
        ICADData data = this.getCADData(stack);
        if (currPsi >= psi) {
            data.setBattery(currPsi - psi);
            return 0;
        }
        data.setBattery(0);
        return psi - currPsi;
    }

    @Override
    public int getMemorySize(ItemStack stack) {
        int vectors = this.getStatValue(stack, EnumCADStat.SAVED_VECTORS);
        if (vectors == -1) {
            return 255;
        }
        return vectors;
    }

    @Override
    public void setStoredVector(ItemStack stack, int memorySlot, Vector3 vec) throws SpellRuntimeException {
        int size = this.getMemorySize(stack);
        if (memorySlot < 0 || memorySlot >= size) {
            throw new SpellRuntimeException("psi.spellerror.memoryoutofbounds", new Object[0]);
        }
        this.getCADData(stack).setSavedVector(memorySlot, vec);
    }

    @Override
    public Vector3 getStoredVector(ItemStack stack, int memorySlot) throws SpellRuntimeException {
        int size = this.getMemorySize(stack);
        if (memorySlot < 0 || memorySlot >= size) {
            throw new SpellRuntimeException("psi.spellerror.memoryoutofbounds", new Object[0]);
        }
        return this.getCADData(stack).getSavedVector(memorySlot);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, @NotNull BlockState state) {
        if (!PieceTrickBreakBlock.doingHarvestCheck.get().booleanValue()) {
            return super.isCorrectToolForDrops(stack, state);
        }
        int level = (Integer)ConfigHandler.COMMON.cadHarvestLevel.get();
        if (level >= 0) {
            return PieceTrickBreakBlock.canHarvest(level, state);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            Component componentName = ISocketable.getSocketedItemName(stack, "psimisc.none");
            tooltip.add((Component)Component.translatable((String)"psimisc.spell_selected", (Object[])new Object[]{componentName}));
            for (EnumCADComponent componentType : EnumSet.allOf(EnumCADComponent.class)) {
                ItemStack componentStack = this.getComponentInSlot(stack, componentType);
                MutableComponent name = Component.translatable((String)"psimisc.none");
                if (!componentStack.isEmpty()) {
                    name = componentStack.getHoverName();
                }
                MutableComponent componentTypeName = Component.translatable((String)componentType.getName()).withStyle(ChatFormatting.GREEN);
                tooltip.add((Component)componentTypeName.append(": ").append((Component)name));
                for (EnumCADStat stat : (EnumCADStat[])EnumCADStat.class.getEnumConstants()) {
                    if (stat.getSourceType() != componentType) continue;
                    String shrt = stat.getName();
                    int statVal = this.getStatValue(stack, stat);
                    Object statValStr = statVal == -1 ? "\u221e" : "" + statVal;
                    tooltip.add((Component)Component.translatable((String)shrt).withStyle(ChatFormatting.AQUA).append(": " + (String)statValStr));
                }
            }
        });
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }
}

