/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.common.item.base.IHUDItem;
import vazkii.psi.common.item.base.ModDataComponents;

public class ItemVectorRuler
extends Item
implements IHUDItem {
    public ItemVectorRuler(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public static Vector3 getRulerVector(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof ItemVectorRuler)) continue;
            return ((ItemVectorRuler)stack.getItem()).getVector(stack);
        }
        return Vector3.zero;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        ItemStack stack = ctx.getPlayer().getItemInHand(ctx.getHand());
        if (!stack.has(ModDataComponents.SRC_POS) || ctx.getPlayer().isShiftKeyDown()) {
            stack.set(ModDataComponents.SRC_POS, (Object)pos);
            stack.remove(ModDataComponents.DST_POS);
        } else {
            stack.set(ModDataComponents.DST_POS, (Object)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.literal((String)this.getVector(stack).toString()));
    }

    public Vector3 getVector(ItemStack stack) {
        BlockPos src = (BlockPos)stack.getOrDefault(ModDataComponents.SRC_POS, (Object)BlockPos.ZERO);
        if (!stack.has(ModDataComponents.DST_POS)) {
            return Vector3.fromBlockPos(src);
        }
        BlockPos dst = (BlockPos)stack.getOrDefault(ModDataComponents.DST_POS, (Object)BlockPos.ZERO);
        return Vector3.fromBlockPos(dst.subtract((Vec3i)src));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(GuiGraphics graphics, float partTicks, int screenWidth, int screenHeight, ItemStack stack) {
        String s = this.getVector(stack).toString();
        Font font = Minecraft.getInstance().font;
        int w = font.width(s);
        graphics.drawString(font, s, (float)screenWidth / 2.0f - (float)w / 2.0f, (float)screenHeight / 2.0f + 10.0f, -1, false);
    }
}

