/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.component;

import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.common.item.base.ModDataComponents;
import vazkii.psi.common.item.component.ItemCADComponent;

public class ItemCADColorizer
extends ItemCADComponent
implements ICADColorizer {
    private final DyeColor color;

    public ItemCADColorizer(Item.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public ItemCADColorizer(Item.Properties properties) {
        super(properties);
        this.color = DyeColor.BLACK;
    }

    private static String getProperDyeName(DyeColor color) {
        return color.getSerializedName();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(ItemStack stack) {
        return FastColor.ARGB32.opaque((int)this.color.getTextColor());
    }

    @Override
    public String getContributorName(ItemStack stack) {
        return (String)stack.getOrDefault(ModDataComponents.CONTRIBUTOR, (Object)"");
    }

    @Override
    public void setContributorName(ItemStack stack, String name) {
        stack.set(ModDataComponents.CONTRIBUTOR, (Object)name);
    }
}

