/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.component;

import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.common.Psi;

public abstract class ItemCADComponent
extends Item
implements ICADComponent {
    private final HashMap<EnumCADStat, Integer> stats = new HashMap();

    public ItemCADComponent(Item.Properties properties) {
        super(properties.stacksTo(1));
        this.registerStats();
    }

    public static void addStatToStack(ItemStack stack, EnumCADStat stat, int value) {
        if (stack.getItem() instanceof ItemCADComponent) {
            ((ItemCADComponent)stack.getItem()).addStat(stat, value);
        } else {
            Psi.logger.error("Tried to add stats to non-component ItemStack: {}", (Object)stack.getItem().getDescription());
        }
    }

    public static void addStatToStack(Item item, EnumCADStat stat, int value) {
        if (item instanceof ItemCADComponent) {
            ((ItemCADComponent)item).addStat(stat, value);
        } else {
            Psi.logger.error("Tried to add stats to non-component Item: {}", (Object)item.getDescription());
        }
    }

    public void registerStats() {
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            EnumCADComponent componentType = this.getComponentType(stack);
            MutableComponent componentName = Component.translatable((String)componentType.getName());
            tooltip.add((Component)Component.translatable((String)"psimisc.component_type", (Object[])new Object[]{componentName}));
            for (EnumCADStat stat : (EnumCADStat[])EnumCADStat.class.getEnumConstants()) {
                if (stat.getSourceType() != componentType) continue;
                int statVal = this.getCADStatValue(stack, stat);
                Object statValStr = statVal == -1 ? "\u221e" : "" + statVal;
                MutableComponent name = Component.translatable((String)stat.getName()).withStyle(ChatFormatting.AQUA);
                tooltip.add((Component)Component.literal((String)" ").append((Component)name).append(": " + (String)statValStr));
            }
        });
    }

    public void addStat(HashMap<EnumCADStat, Integer> stats) {
        stats.forEach(this::addStat);
    }

    public void addStat(EnumCADStat stat, int value) {
        this.stats.put(stat, value);
    }

    @Override
    public int getCADStatValue(ItemStack stack, EnumCADStat stat) {
        if (this.stats.containsKey((Object)stat)) {
            return this.stats.get((Object)stat);
        }
        return 0;
    }
}

