/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public record MessageChangeControllerSlot(int controlSlot, int slot) implements CustomPacketPayload
{
    public static final ResourceLocation ID = Psi.location("message_change_controller_slot");
    public static final CustomPacketPayload.Type<MessageChangeControllerSlot> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageChangeControllerSlot> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageChangeControllerSlot::controlSlot, (StreamCodec)ByteBufCodecs.INT, MessageChangeControllerSlot::slot, MessageChangeControllerSlot::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (!stack.isEmpty() && stack.getItem() instanceof ISocketableController) {
                ((ISocketableController)stack.getItem()).setSelectedSlot(player, stack, this.controlSlot, this.slot);
            } else {
                stack = player.getItemInHand(InteractionHand.OFF_HAND);
                if (!stack.isEmpty() && stack.getItem() instanceof ISocketableController) {
                    ((ISocketableController)stack.getItem()).setSelectedSlot(player, stack, this.controlSlot, this.slot);
                }
            }
            PlayerDataHandler.get(player).stopLoopcast();
        });
    }
}

