/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickMoveBlock
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> target;

    public PieceTrickMoveBlock(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(10.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(15.0));
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.GREEN, false, false);
        this.addParam(this.target);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 10);
        meta.addStat(EnumSpellStat.COST, 15);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        ItemStack tool = context.getHarvestTool();
        Vector3 positionVal = this.getParamValue(context, this.position);
        Vector3 targetVal = this.getParamValue(context, this.target);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector", new Object[0]);
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius", new Object[0]);
        }
        Level world = context.focalPoint.getCommandSenderWorld();
        BlockPos pos = positionVal.toBlockPos();
        if (context.positionBroken != null && context.positionBroken.getBlockPos().equals((Object)pos)) {
            return null;
        }
        BlockState state = world.getBlockState(pos);
        if (world.getBlockEntity(pos) != null || state.getPistonPushReaction() != PushReaction.NORMAL || state.getDestroySpeed((BlockGetter)world, pos) == -1.0f || !PieceTrickBreakBlock.canHarvestBlock(state, context.caster, world, pos, tool)) {
            return null;
        }
        BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, context.caster, world, pos, tool);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return null;
        }
        if (!targetVal.isAxial() || targetVal.isZero()) {
            return null;
        }
        Vector3 axis = targetVal.normalize();
        int x = pos.getX() + (int)axis.x;
        int y = pos.getY() + (int)axis.y;
        int z = pos.getZ() + (int)axis.z;
        BlockPos pos1 = new BlockPos(x, y, z);
        BlockState state1 = world.getBlockState(pos1);
        if (!world.mayInteract(context.caster, pos) || !world.mayInteract(context.caster, pos1)) {
            return null;
        }
        if (state1.isAir() || state1.canBeReplaced()) {
            world.setBlock(pos1, state, 3);
            world.removeBlock(pos, false);
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        return null;
    }
}

