/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rpgstylemoreweaponsr.network;

import java.util.function.Supplier;
import net.mcreator.rpgstylemoreweaponsr.RpgStyleMoreWeaponsRMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class RpgStyleMoreWeaponsRModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"rpg_style_more_weapons_r");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        RpgStyleMoreWeaponsRMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"rpg_style_more_weapons_r", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean BattleAxe = false;
        public boolean Greatsword = false;
        public boolean Knife = false;
        public double Jump = 0.0;
        public double Walk = 0.0;
        public boolean AbilityUse = false;
        public boolean Immunnity = false;
        public double Xdata = 0.0;
        public double Ydata = 0.0;
        public double Zdata = 0.0;
        public boolean PaladinArmor = false;
        public boolean BerserkArmor = false;
        public boolean AssassinArmor = false;
        public double PaladinArmorAbility = 0.0;
        public double BerserkArmorAbility = 0.0;
        public double AssassinArmorAbility = 0.0;
        public double Xvol = 0.0;
        public double Zvol = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("BattleAxe", this.BattleAxe);
            nbt.putBoolean("Greatsword", this.Greatsword);
            nbt.putBoolean("Knife", this.Knife);
            nbt.putDouble("Jump", this.Jump);
            nbt.putDouble("Walk", this.Walk);
            nbt.putBoolean("AbilityUse", this.AbilityUse);
            nbt.putBoolean("Immunnity", this.Immunnity);
            nbt.putDouble("Xdata", this.Xdata);
            nbt.putDouble("Ydata", this.Ydata);
            nbt.putDouble("Zdata", this.Zdata);
            nbt.putBoolean("PaladinArmor", this.PaladinArmor);
            nbt.putBoolean("BerserkArmor", this.BerserkArmor);
            nbt.putBoolean("AssassinArmor", this.AssassinArmor);
            nbt.putDouble("PaladinArmorAbility", this.PaladinArmorAbility);
            nbt.putDouble("BerserkArmorAbility", this.BerserkArmorAbility);
            nbt.putDouble("AssassinArmorAbility", this.AssassinArmorAbility);
            nbt.putDouble("Xvol", this.Xvol);
            nbt.putDouble("Zvol", this.Zvol);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.BattleAxe = nbt.getBoolean("BattleAxe");
            this.Greatsword = nbt.getBoolean("Greatsword");
            this.Knife = nbt.getBoolean("Knife");
            this.Jump = nbt.getDouble("Jump");
            this.Walk = nbt.getDouble("Walk");
            this.AbilityUse = nbt.getBoolean("AbilityUse");
            this.Immunnity = nbt.getBoolean("Immunnity");
            this.Xdata = nbt.getDouble("Xdata");
            this.Ydata = nbt.getDouble("Ydata");
            this.Zdata = nbt.getDouble("Zdata");
            this.PaladinArmor = nbt.getBoolean("PaladinArmor");
            this.BerserkArmor = nbt.getBoolean("BerserkArmor");
            this.AssassinArmor = nbt.getBoolean("AssassinArmor");
            this.PaladinArmorAbility = nbt.getDouble("PaladinArmorAbility");
            this.BerserkArmorAbility = nbt.getDouble("BerserkArmorAbility");
            this.AssassinArmorAbility = nbt.getDouble("AssassinArmorAbility");
            this.Xvol = nbt.getDouble("Xvol");
            this.Zvol = nbt.getDouble("Zvol");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            if (!event.isWasDeath()) {
                clone.BattleAxe = original.BattleAxe;
                clone.Greatsword = original.Greatsword;
                clone.Knife = original.Knife;
                clone.Jump = original.Jump;
                clone.Walk = original.Walk;
                clone.AbilityUse = original.AbilityUse;
                clone.Immunnity = original.Immunnity;
                clone.Xdata = original.Xdata;
                clone.Ydata = original.Ydata;
                clone.Zdata = original.Zdata;
                clone.PaladinArmor = original.PaladinArmor;
                clone.BerserkArmor = original.BerserkArmor;
                clone.AssassinArmor = original.AssassinArmor;
                clone.PaladinArmorAbility = original.PaladinArmorAbility;
                clone.BerserkArmorAbility = original.BerserkArmorAbility;
                clone.AssassinArmorAbility = original.AssassinArmorAbility;
                clone.Xvol = original.Xvol;
                clone.Zvol = original.Zvol;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

