/*
 * Decompiled with CFR 0.152.
 */
package fuzs.respawninganimals.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.respawninganimals.handler.AnimalSpawningHandler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.Level;

public class AnimalPersistenceHandler {
    public static void onEndEntityTick(Entity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            Mob mob;
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof Mob && !(mob = (Mob)entity).isPersistenceRequired() && AnimalSpawningHandler.isAllowedToDespawn(mob, serverLevel.getGameRules()) && AnimalPersistenceHandler.requiresCustomPersistence(mob)) {
                mob.setPersistenceRequired();
            }
        }
    }

    private static boolean requiresCustomPersistence(Mob mob) {
        OwnableEntity ownable;
        Animal animal;
        if (mob instanceof Animal && (animal = (Animal)mob).isInLove()) {
            return true;
        }
        if (mob.isLeashed()) {
            return true;
        }
        return mob instanceof OwnableEntity && (ownable = (OwnableEntity)mob).getOwnerUUID() != null;
    }

    public static EventResult onAnimalTame(Animal animal, Player player) {
        AnimalPersistenceHandler.setPersistenceForVolatileAnimal((Entity)animal);
        return EventResult.PASS;
    }

    public static EventResult onStartRiding(Level level, Entity rider, Entity vehicle) {
        if (rider instanceof Player) {
            AnimalPersistenceHandler.setPersistenceForVolatileAnimal(vehicle);
        } else if (vehicle instanceof VehicleEntity) {
            AnimalPersistenceHandler.setPersistenceForVolatileAnimal(rider);
        }
        return EventResult.PASS;
    }

    private static void setPersistenceForVolatileAnimal(Entity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            Mob mob;
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof Mob && (mob = (Mob)entity).getType().getCategory() == MobCategory.CREATURE && !mob.isPersistenceRequired() && AnimalSpawningHandler.isAllowedToDespawn(mob, serverLevel.getGameRules())) {
                mob.setPersistenceRequired();
            }
        }
    }
}

