/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.EndRemasteredCompat;
import einstein.subtle_effects.configs.CommandBlockSpawnType;
import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.mixin.client.block.AmethystClusterBlockAccessor;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.PositionParticleOptions;
import einstein.subtle_effects.util.BlockTickerProvider;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModBlockTickers {
    public static final Map<Block, BlockTickerProvider> REGISTERED = new HashMap<Block, BlockTickerProvider>();
    public static final Map<Predicate<BlockState>, BlockTickerProvider> REGISTERED_SPECIAL = new HashMap<Predicate<BlockState>, BlockTickerProvider>();

    public static void init() {
        REGISTERED.clear();
        REGISTERED_SPECIAL.clear();
        if (CompatHelper.IS_END_REMASTERED_LOADED.get().booleanValue()) {
            EndRemasteredCompat.init();
        }
        ModBlockTickers.register((BlockState state) -> ModConfigs.BLOCKS.redstoneDustEmittingBlocks.contains((Object)state.getBlock()), () -> ModConfigs.BLOCKS.redstoneBlockDust && !ModConfigs.BLOCKS.redstoneDustEmittingBlocks.isEmpty(), (BlockState state, Level level, BlockPos pos, RandomSource random) -> ParticleSpawnUtil.spawnParticlesAroundBlock((ParticleOptions)DustParticleOptions.REDSTONE, level, pos, random, ModConfigs.BLOCKS.redstoneBlockDustDensity.getPerSideChance()));
        ModBlockTickers.register((BlockState state) -> ModConfigs.BLOCKS.glowstoneDustEmittingBlocks.contains((Object)state.getBlock()), () -> ModConfigs.BLOCKS.glowstoneBlockDust && !ModConfigs.BLOCKS.glowstoneDustEmittingBlocks.isEmpty(), (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (ModConfigs.BLOCKS.netherOnlyGlowstoneBlockDust && !level.dimension().equals(Level.NETHER)) {
                return;
            }
            ParticleSpawnUtil.spawnParticlesAroundBlock((ParticleOptions)Util.GLOWSTONE_DUST_PARTICLES, level, pos, random, ModConfigs.BLOCKS.glowstoneBlockDustDensity.getPerSideChance());
        });
        ModBlockTickers.register(Blocks.TORCHFLOWER, () -> ModConfigs.BLOCKS.torchflowerSmoke.isEnabled() || ModConfigs.BLOCKS.torchflowerFlames, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            Vec3 center = state.getShape((BlockGetter)level, pos).bounds().getCenter();
            Vec3 offsetPos = new Vec3((double)pos.getX() + center.x(), (double)pos.getY() + center.y() + 0.3, (double)pos.getZ() + center.z());
            if (ModConfigs.BLOCKS.torchflowerSmoke.isEnabled() && random.nextInt(3) == 0) {
                level.addParticle(ModConfigs.BLOCKS.torchflowerSmoke.getParticle().get(), offsetPos.x(), offsetPos.y(), offsetPos.z(), 0.0, 0.0, 0.0);
            }
            if (ModConfigs.BLOCKS.torchflowerFlames && random.nextInt(5) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, offsetPos.x(), offsetPos.y(), offsetPos.z(), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register(Blocks.DRAGON_EGG, () -> ModConfigs.BLOCKS.dragonEggParticles, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            for (int i = 0; i < 3; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5 + 0.25 * (double)MathUtil.nextSign(random), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + 0.5 + 0.25 * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random), (random.nextDouble() - 0.5) * 0.125, MathUtil.nextNonAbsDouble(random));
            }
        });
        ModBlockTickers.register(Blocks.LAVA_CAULDRON, () -> ModConfigs.BLOCKS.lavaCauldronEffects, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (!level.getFluidState(pos.above()).isEmpty()) {
                return;
            }
            ((LavaFluid.Source)Fluids.LAVA).animateTick(level, pos, (FluidState)Fluids.LAVA.defaultFluidState().setValue((Property)BlockStateProperties.FALLING, (Comparable)Boolean.valueOf(false)), random);
        });
        ModBlockTickers.register(Blocks.BEACON, () -> ModConfigs.BLOCKS.beaconParticlesDisplayType != ModBlockConfigs.BeaconParticlesDisplayType.OFF, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            BeaconBlockEntity beaconBlockEntity;
            List sections;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BeaconBlockEntity && !(sections = (beaconBlockEntity = (BeaconBlockEntity)blockEntity).getBeamSections()).isEmpty() && (sections.size() <= 1 || ModConfigs.BLOCKS.beaconParticlesDisplayType != ModBlockConfigs.BeaconParticlesDisplayType.NOT_COLORED)) {
                PositionParticleOptions options = new PositionParticleOptions(ModParticles.BEACON.get(), beaconBlockEntity.getBlockPos());
                for (int i = 0; i < (Integer)ModConfigs.BLOCKS.beaconParticlesDensity.get(); ++i) {
                    level.addParticle((ParticleOptions)options, (double)pos.getX() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), 0.0, 0.0, 0.0);
                }
            }
        });
        ModBlockTickers.register(Blocks.RESPAWN_ANCHOR, () -> ModConfigs.BLOCKS.respawnAnchorParticles, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            Direction direction;
            if (random.nextInt(5) == 0 && (direction = Direction.getRandom((RandomSource)random)) != Direction.UP) {
                BlockPos relativePos = pos.relative(direction);
                BlockState relativeState = level.getBlockState(relativePos);
                if (!state.canOcclude() || !relativeState.isFaceSturdy((BlockGetter)level, relativePos, direction.getOpposite())) {
                    ParticleSpawnUtil.spawnParticlesOnSide((ParticleOptions)ParticleTypes.DRIPPING_OBSIDIAN_TEAR, 0.1f, direction, level, pos, random, 0.0, 0.0, 0.0);
                }
            }
        });
        ModBlockTickers.register(Blocks.WATER_CAULDRON, () -> ModConfigs.BLOCKS.steam.steamingWaterCauldron || ModConfigs.BLOCKS.steam.boilingWaterCauldron, (BlockState state, Level level, BlockPos pos, RandomSource random) -> ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, false, 0.5625 + (double)((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL)).intValue() * 0.1875, ModConfigs.BLOCKS.steam.steamingWaterCauldron, ModConfigs.BLOCKS.steam.boilingWaterCauldron));
        ModBlockTickers.register(Blocks.END_GATEWAY, () -> ModConfigs.BLOCKS.endPortalParticles, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            for (int i = 0; i < 5; ++i) {
                level.addParticle((ParticleOptions)ModParticles.END_PORTAL.get(), (double)(pos.getX() + (random.nextInt(3) - 1)) + random.nextDouble(), (double)(pos.getY() + (random.nextInt(3) - 1)) + random.nextDouble(), (double)(pos.getZ() + (random.nextInt(3) - 1)) + random.nextDouble(), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register((BlockState state) -> state.getBlock() instanceof CampfireBlock && (Boolean)state.getValue((Property)CampfireBlock.LIT) != false, () -> ((Float)ModConfigs.BLOCKS.campfireSizzlingSoundVolume.get()).floatValue() > 0.0f, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof CampfireBlockEntity) {
                CampfireBlockEntity blockEntity = (CampfireBlockEntity)patt0$temp;
                for (ItemStack stack : blockEntity.getItems()) {
                    if (stack.isEmpty() || random.nextInt(5) != 0) continue;
                    Util.playClientSound(pos, ModSounds.CAMPFIRE_SIZZLE.get(), SoundSource.BLOCKS, Mth.nextFloat((RandomSource)random, (float)0.3f, (float)0.7f) * (((Float)ModConfigs.BLOCKS.campfireSizzlingSoundVolume.get()).floatValue() * 2.0f), Mth.nextFloat((RandomSource)random, (float)1.0f, (float)1.5f));
                }
            }
        });
        ModBlockTickers.register((BlockState state) -> state.getBlock() instanceof CommandBlock, () -> ModConfigs.BLOCKS.commandBlockParticles != CommandBlockSpawnType.OFF, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (ModConfigs.BLOCKS.commandBlockParticles == CommandBlockSpawnType.NOT_CREATIVE && Minecraft.getInstance().player.isCreative()) {
                return;
            }
            ParticleSpawnUtil.spawnCmdBlockParticles(level, Vec3.atCenterOf((Vec3i)pos), random, (direction, relativePos) -> !Util.isSolidOrNotEmpty(level, BlockPos.containing((Position)relativePos)));
        });
        ModBlockTickers.register((BlockState state) -> ModConfigs.BLOCKS.amethystSparkleEmittingBlocks.contains((Object)state.getBlock()), () -> ModConfigs.BLOCKS.amethystSparkleDisplayType == ModBlockConfigs.AmethystSparkleDisplayType.ON && !ModConfigs.BLOCKS.amethystSparkleEmittingBlocks.isEmpty(), (BlockState state, Level level, BlockPos pos, RandomSource random) -> ParticleSpawnUtil.spawnParticlesAroundBlock((ParticleOptions)ModParticles.AMETHYST_SPARKLE.get(), level, pos, random, 5));
        ModBlockTickers.register((BlockState state) -> state.getBlock() instanceof AmethystClusterBlock, () -> ModConfigs.BLOCKS.amethystSparkleSounds, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            int chance;
            if (((AmethystClusterBlockAccessor)state.getBlock()).getHeight() >= 5.0f && (chance = random.nextInt(100)) <= 5) {
                if (chance == 0) {
                    Util.playClientSound(pos, ModSounds.AMETHYST_CLUSTER_CHIME.get(), SoundSource.BLOCKS, Mth.nextFloat((RandomSource)random, (float)0.15f, (float)0.3f), 1.0f);
                    return;
                }
                Util.playClientSound(pos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, Mth.nextFloat((RandomSource)random, (float)0.07f, (float)1.5f), Mth.nextFloat((RandomSource)random, (float)0.07f, (float)1.3f));
            }
        });
        ModBlockTickers.register((BlockState state) -> state.is(Blocks.LARGE_AMETHYST_BUD) || state.is(Blocks.AMETHYST_CLUSTER), () -> ModConfigs.BLOCKS.amethystSparkleDisplayType != ModBlockConfigs.AmethystSparkleDisplayType.OFF, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            AmethystClusterBlockAccessor block = (AmethystClusterBlockAccessor)state.getBlock();
            float height = block.getHeight();
            if (height >= 5.0f && random.nextInt(5) == 0) {
                float offset = block.getAABBOffset() / 16.0f + 0.0625f;
                float pixelHeight = height / 16.0f;
                level.addParticle((ParticleOptions)ModParticles.AMETHYST_SPARKLE.get(), (double)pos.getX() + 0.5 + MathUtil.nextNonAbsDouble(random, offset), (double)((float)pos.getY() + pixelHeight + pixelHeight / 2.0f), (double)pos.getZ() + 0.5 + MathUtil.nextNonAbsDouble(random, offset), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register(Blocks.FLOWERING_AZALEA_LEAVES, () -> ModConfigs.BLOCKS.floweringAzaleaPetals, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            BlockPos belowPos;
            BlockState belowState;
            if (random.nextInt(ModConfigs.BLOCKS.rainIncreasesLeavesSpawningParticles && Util.isRainingAt(level, pos) ? 5 : 10) == 0 && !Block.isFaceFull((VoxelShape)(belowState = level.getBlockState(belowPos = pos.below())).getCollisionShape((BlockGetter)level, belowPos), (Direction)Direction.UP)) {
                ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)((ParticleOptions)ModParticles.AZALEA_PETAL.get()));
            }
        });
        ModBlockTickers.register(Blocks.SCULK, () -> ModConfigs.BLOCKS.sculkBlockSculkDust, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (random.nextInt(20) == 0) {
                ParticleSpawnUtil.spawnParticlesAroundBlock((ParticleOptions)ModParticles.SCULK_DUST.get(), level, pos, random, 0);
            }
        });
        ModBlockTickers.register(Blocks.SCULK_VEIN, () -> ModConfigs.BLOCKS.sculkVeinSculkDust, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (random.nextInt(30) == 0) {
                ParticleSpawnUtil.spawnParticlesAroundBlock((ParticleOptions)ModParticles.SCULK_DUST.get(), level, pos, random, -0.9375f, direction -> direction.getAxis() != Direction.Axis.Y);
            }
        });
        ModBlockTickers.register(Blocks.CALIBRATED_SCULK_SENSOR, () -> ModConfigs.BLOCKS.calibratedSculkSensorAmethystSparkle, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (random.nextInt(SculkSensorBlock.getPhase((BlockState)state) == SculkSensorPhase.ACTIVE ? 1 : 5) == 0) {
                level.addParticle((ParticleOptions)ModParticles.AMETHYST_SPARKLE.get(), (double)pos.getX() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.25), (double)pos.getY() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.75), (double)pos.getZ() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.25), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register(Blocks.END_PORTAL_FRAME, () -> ModConfigs.BLOCKS.endPortalFrameParticlesDisplayType != ModBlockConfigs.EndPortalFrameParticlesDisplayType.OFF, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (!((Boolean)state.getValue((Property)EndPortalFrameBlock.HAS_EYE)).booleanValue()) {
                return;
            }
            ParticleSpawnUtil.spawnEndPortalParticles(level, pos, random, ModConfigs.BLOCKS.endPortalFrameParticlesDisplayType.particle.apply(level, pos), ModConfigs.BLOCKS.endPortalFrameParticlesDisplayType.count);
        });
        ModBlockTickers.register((BlockState state) -> state.getBlock() instanceof FallingBlock, () -> ModConfigs.BLOCKS.fallingBlocks.weakSupportDust, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            Block block;
            if (random.nextInt(16) < (Integer)ModConfigs.BLOCKS.fallingBlocks.weakSupportDustDensity.get() && ModConfigs.BLOCKS.fallingBlocks.dustyBlocks.contains((Object)(block = state.getBlock())) && !Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.below())) {
                BlockState blockState;
                if (block instanceof BrushableBlock) {
                    BrushableBlock brushableBlock = (BrushableBlock)block;
                    blockState = brushableBlock.getTurnsInto().defaultBlockState();
                } else {
                    blockState = state;
                }
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, blockState), (double)pos.getX() + random.nextDouble(), (double)pos.getY() - 0.0625, (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register(Blocks.BREWING_STAND, () -> ModConfigs.BLOCKS.sparks.brewingStandSparks, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            for (int i = 0; i < 5; ++i) {
                level.addParticle((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random, SparkParticle.BLAZE_COLORS), (double)pos.getX() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.125), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.125), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register(Blocks.DECORATED_POT, () -> ModConfigs.BLOCKS.decoratedPotsSpawnBubbles, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            for (int i = 0; i < random.nextInt(2); ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, (double)pos.getX() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.125), (double)(pos.getY() + 1) + MathUtil.nextNonAbsDouble(random, 0.25), (double)pos.getZ() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.125), 0.0, 0.0, 0.0);
            }
        });
    }

    private static void register(Block block, Supplier<Boolean> isEnabled, BlockTickerProvider provider) {
        if (isEnabled.get().booleanValue() && REGISTERED.put(block, provider) != null) {
            SubtleEffects.LOGGER.error("Found duplicate block tickers using {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)block));
        }
    }

    private static void register(Predicate<BlockState> predicate, Supplier<Boolean> isEnabled, BlockTickerProvider provider) {
        if (isEnabled.get().booleanValue()) {
            REGISTERED_SPECIAL.put(predicate, provider);
        }
    }
}

