/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.configs.CommandBlockSpawnType;
import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.configs.items.ItemRarityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.BooleanParticleOptions;
import einstein.subtle_effects.ticking.tickers.entity.DrowningTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityCauldronTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityFireTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityTickerManager;
import einstein.subtle_effects.ticking.tickers.entity.FrostyBreathTicker;
import einstein.subtle_effects.ticking.tickers.entity.HeartbeatTicker;
import einstein.subtle_effects.ticking.tickers.entity.HumanoidPotionRingTicker;
import einstein.subtle_effects.ticking.tickers.entity.IronGolemTicker;
import einstein.subtle_effects.ticking.tickers.entity.ItemRarityTicker;
import einstein.subtle_effects.ticking.tickers.entity.MinecartSparksTicker;
import einstein.subtle_effects.ticking.tickers.entity.MobSkullShaderTicker;
import einstein.subtle_effects.ticking.tickers.entity.SlimeTrailTicker;
import einstein.subtle_effects.ticking.tickers.entity.StomachGrowlingTicker;
import einstein.subtle_effects.ticking.tickers.entity.WitchPotionRingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.BatSleepingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.CatSleepingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.FoxSleepingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.PlayerSleepingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.SleepingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.VillagerSleepingTicker;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ModEntityTickers {
    private static final Predicate<Entity> LOCAL_PLAYER = entity -> entity.equals((Object)Minecraft.getInstance().player);

    public static void init() {
        EntityTickerManager.register(entity -> true, EntityCauldronTicker::new);
        EntityTickerManager.register(entity -> !(entity instanceof LightningBolt), EntityFireTicker::new);
        EntityTickerManager.register(entity -> entity instanceof LivingEntity, ModEntityTickers::getSleepingTicker);
        EntityTickerManager.register(entity -> entity instanceof AbstractMinecart && ModConfigs.ENTITIES.minecartSparksDisplayType != ModEntityConfigs.MinecartSparksDisplayType.OFF, MinecartSparksTicker::new);
        EntityTickerManager.register(LOCAL_PLAYER.and(entity -> (Integer)ModConfigs.ENTITIES.humanoids.player.stomachGrowlingThreshold.get() > 0), StomachGrowlingTicker::new);
        EntityTickerManager.register(LOCAL_PLAYER.and(entity -> ModConfigs.GENERAL.mobSkullShaders), MobSkullShaderTicker::new);
        EntityTickerManager.register(LOCAL_PLAYER.and(entity -> (Integer)ModConfigs.ENTITIES.humanoids.player.heartBeatingThreshold.get() > 0), HeartbeatTicker::new);
        EntityTickerManager.register(entity -> ModEntityTickers.isHumanoid(entity, !entity.level().dimension().equals(Level.NETHER)) && ModConfigs.ENTITIES.humanoids.drowningBubblesDisplayType.isEnabled(), DrowningTicker::new);
        EntityTickerManager.register(entity -> ModEntityTickers.isHumanoid(entity, !entity.level().dimension().equals(Level.NETHER)) && ModConfigs.ENTITIES.humanoids.frostyBreath.displayType.isEnabled(), FrostyBreathTicker::new);
        EntityTickerManager.register(entity -> entity.getType().equals(EntityType.SLIME) && ModConfigs.ENTITIES.slimeTrails, entity -> new SlimeTrailTicker<Slime>((Slime)entity, ModParticles.SLIME_TRAIL));
        EntityTickerManager.register(entity -> entity.getType().equals(EntityType.MAGMA_CUBE) && ModConfigs.ENTITIES.magmaCubeTrails, entity -> new SlimeTrailTicker<MagmaCube>((MagmaCube)entity, ModParticles.MAGMA_CUBE_TRAIL));
        EntityTickerManager.register(entity -> entity.getType().equals(EntityType.IRON_GOLEM) && ModConfigs.ENTITIES.ironGolemCrackParticles, IronGolemTicker::new);
        EntityTickerManager.register(entity -> entity instanceof ItemEntity && ModConfigs.ITEMS.itemRarity.particlesDisplayType != ItemRarityConfigs.DisplayType.OFF, ItemRarityTicker::new);
        EntityTickerManager.register(entity -> entity instanceof Witch && ModConfigs.ENTITIES.humanoids.NPCsHavePotionRings && ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.isEnabled(), WitchPotionRingTicker::new);
        EntityTickerManager.register(entity -> ModEntityTickers.isNPC(entity, true) && ModConfigs.ENTITIES.humanoids.NPCsHavePotionRings && ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.isEnabled(), entity -> new HumanoidPotionRingTicker<LivingEntity>((LivingEntity)entity));
        EntityTickerManager.registerSimple(entity -> entity instanceof Player && ModConfigs.ENTITIES.dustClouds.playerRunning, true, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.isRainingAt(entity.blockPosition())) {
                return;
            }
            Player player = (Player)entity;
            if (ModConfigs.ENTITIES.dustClouds.playerRunningRequiresSpeed && !player.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                return;
            }
            if (player.canSpawnSprintParticle() && player.onGround() && !player.isUsingItem() && random.nextBoolean()) {
                level.addParticle((ParticleOptions)ModParticles.SMALL_DUST_CLOUD.get(), entity.getRandomX(1.0), entity.getY() + Math.max(Math.min((double)random.nextFloat(), 0.3), 0.2), entity.getRandomZ(1.0), 0.0, random.nextDouble(), 0.0);
            }
        });
        EntityTickerManager.registerSimple(entity -> entity instanceof FallingBlockEntity && ModConfigs.BLOCKS.fallingBlocks.whileFallingDust, false, (entity, level, random) -> {
            BlockState state;
            Block block;
            boolean isInWater;
            FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
            int startDistance = (Integer)ModConfigs.BLOCKS.fallingBlocks.whileFallingDustStartDistance.get();
            float fallDistance = fallingBlock.fallDistance;
            boolean bl = isInWater = fallingBlock.isInWater() && ModConfigs.BLOCKS.fallingBlocks.replaceDustWithBubblesUnderwater;
            if (fallDistance <= (float)startDistance && !isInWater) {
                return;
            }
            if (!fallingBlock.onGround() && !fallingBlock.isNoGravity() && ModConfigs.BLOCKS.fallingBlocks.dustyBlocks.contains((Object)(block = (state = fallingBlock.getBlockState()).getBlock()))) {
                double size = startDistance > 0 ? (fallDistance <= (float)startDistance + (float)startDistance / 3.0f * 2.0f ? 0.5 : 1.0) : 1.0;
                for (int i = 0; i < (size == 1.0 ? 2 : 1); ++i) {
                    SimpleParticleType simpleParticleType;
                    if (isInWater) {
                        simpleParticleType = ParticleTypes.BUBBLE;
                    } else {
                        BlockState blockState;
                        if (block instanceof BrushableBlock) {
                            BrushableBlock brushableBlock = (BrushableBlock)block;
                            blockState = brushableBlock.getTurnsInto().defaultBlockState();
                        } else {
                            blockState = state;
                        }
                        simpleParticleType = new BlockParticleOption(ParticleTypes.FALLING_DUST, blockState);
                    }
                    level.addParticle((ParticleOptions)simpleParticleType, entity.getRandomX(size), entity.getY() + 0.05, entity.getRandomZ(size), 0.0, 0.0, 0.0);
                }
            }
        });
        EntityTickerManager.registerSimple(EntityType.SNOWBALL, false, () -> (Double)ModConfigs.ITEMS.projectiles.snowballTrailDensity.get() > 0.0, (entity, level, random) -> {
            if (ModEntityTickers.shouldSpawn(random, ModConfigs.ITEMS.projectiles.snowballTrailDensity)) {
                Vec3 deltaMovement = entity.getDeltaMovement();
                level.addParticle((ParticleOptions)ModParticles.SNOWBALL_TRAIL.get(), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), deltaMovement.x * 0.5, deltaMovement.y, deltaMovement.z * 0.5);
            }
        });
        EntityTickerManager.registerSimple(EntityType.ENDER_PEARL, false, () -> ModConfigs.ITEMS.projectiles.enderPearlTrail, (entity, level, random) -> {
            for (int i = 0; i < 10; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.PORTAL, entity.getRandomX(2.0), entity.getRandomY(), entity.getRandomZ(2.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(EntityType.ALLAY, true, () -> (Double)ModConfigs.ENTITIES.allayMagicDensity.get() > 0.0, (entity, level, random) -> {
            if (ModEntityTickers.shouldSpawn(random, ModConfigs.ENTITIES.allayMagicDensity)) {
                level.addParticle((ParticleOptions)ModParticles.ALLAY_MAGIC.get(), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), MathUtil.nextNonAbsDouble(random, 0.04), 0.0, MathUtil.nextNonAbsDouble(random, 0.04));
            }
        });
        EntityTickerManager.registerSimple(EntityType.VEX, true, () -> (Double)ModConfigs.ENTITIES.vexMagicDensity.get() > 0.0, (entity, level, random) -> {
            if (ModEntityTickers.shouldSpawn(random, ModConfigs.ENTITIES.vexMagicDensity)) {
                level.addParticle((ParticleOptions)new BooleanParticleOptions(ModParticles.VEX_MAGIC.get(), entity.isCharging()), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), MathUtil.nextNonAbsDouble(random, 0.04), 0.0, MathUtil.nextNonAbsDouble(random, 0.04));
            }
        });
        EntityTickerManager.registerSimple(EntityType.CAMEL, true, () -> ModConfigs.ENTITIES.dustClouds.mobRunning, (entity, level, random) -> {
            if (entity.isDashing() && entity.onGround()) {
                for (int i = 0; i < 10; ++i) {
                    ParticleSpawnUtil.spawnCreatureMovementDustCloudsNoConfig((LivingEntity)entity, level, random, 5);
                }
            }
        });
        EntityTickerManager.registerSimple(EntityType.DRAGON_FIREBALL, false, () -> ModConfigs.ENTITIES.improvedDragonFireballTrail, (entity, level, random) -> {
            for (int i = 0; i < 10; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, entity.getRandomX(2.0), entity.getRandomY(), entity.getRandomZ(2.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(EntityType.COMMAND_BLOCK_MINECART, false, () -> ModConfigs.ENTITIES.commandBlockMinecartParticles != CommandBlockSpawnType.OFF, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.commandBlockMinecartParticles.canTick() && random.nextInt(10) == 0) {
                ParticleSpawnUtil.spawnCmdBlockParticles(level, entity.position().add(0.0, (double)(-(entity.getDisplayOffset() - 8)) / 16.0 + 0.4266666666666667, 0.0), random, (direction, relativePos) -> true);
            }
        });
        EntityTickerManager.registerSimple(EntityType.TNT, false, () -> ModConfigs.ENTITIES.explosives.tntSparks, (entity, level, random) -> level.addParticle((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random), entity.getRandomX(0.5), entity.getY(1.0), entity.getRandomZ(0.5), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01)));
        EntityTickerManager.registerSimple(EntityType.TNT, false, () -> (Integer)ModConfigs.ENTITIES.explosives.tntFlamesDensity.get() > 0, (entity, level, random) -> {
            if (random.nextInt(10) == 0) {
                int density = (Integer)ModConfigs.ENTITIES.explosives.tntFlamesDensity.get();
                if (density == 1) {
                    level.addParticle((ParticleOptions)ParticleTypes.FLAME, entity.getX(), entity.getY(1.1), entity.getZ(), 0.0, 0.0, 0.0);
                    return;
                }
                for (int i = 0; i < density; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.FLAME, entity.getRandomX(0.7), entity.getRandomY(), entity.getRandomZ(0.7), 0.0, 0.0, 0.0);
                }
            }
        });
        EntityTickerManager.registerSimple(EntityType.END_CRYSTAL, false, () -> ModConfigs.ENTITIES.endCrystalParticles, (entity, level, random) -> {
            if (level.getBlockState(entity.blockPosition()).getBlock() instanceof BaseFireBlock || random.nextInt(3) == 0) {
                level.addParticle((ParticleOptions)ModParticles.END_CRYSTAL.get(), entity.getRandomX(1.0), entity.getRandomY() + MathUtil.nextNonAbsDouble(random), entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(EntityType.SPECTRAL_ARROW, false, () -> ModConfigs.ENTITIES.spectralArrowParticles, (entity, level, random) -> {
            if (random.nextInt(3) == 0) {
                level.addParticle((ParticleOptions)Util.GLOWSTONE_DUST_PARTICLES, entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(EntityType.CREEPER, true, () -> ModConfigs.ENTITIES.explosives.creeperSparks, (entity, level, random) -> {
            if (entity.isIgnited()) {
                for (int i = 0; i < 3; ++i) {
                    level.addParticle((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
                }
            }
        });
        EntityTickerManager.registerSimple(EntityType.CREEPER, true, () -> ModConfigs.ENTITIES.explosives.creeperSmoke.isEnabled(), (entity, level, random) -> {
            if (entity.isIgnited()) {
                level.addParticle(ModConfigs.ENTITIES.explosives.creeperSmoke.getParticle().get(), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
            }
        });
        EntityTickerManager.registerSimple(entity -> entity instanceof LivingEntity && entity.canFreeze() && ModConfigs.ENTITIES.freezingSnowFlakes, false, (entity, level, random) -> {
            if (entity.isFreezing() || entity.getTicksFrozen() > 0 || entity.getInBlockState().is(Blocks.POWDER_SNOW_CAULDRON)) {
                level.addParticle((ParticleOptions)ModParticles.FREEZING.get(), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
        });
    }

    public static boolean shouldSpawn(RandomSource random, ValidatedDouble chanceConfig) {
        return (double)Math.min(random.nextFloat(), 1.0f) < (Double)chanceConfig.get();
    }

    private static SleepingTicker<?> getSleepingTicker(LivingEntity entity) {
        LivingEntity livingEntity = entity;
        Objects.requireNonNull(livingEntity);
        LivingEntity livingEntity2 = livingEntity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractVillager.class, Player.class, Bat.class, Cat.class, Fox.class}, (Object)livingEntity2, n)) {
            case 0 -> {
                AbstractVillager villager = (AbstractVillager)livingEntity2;
                yield new VillagerSleepingTicker(villager);
            }
            case 1 -> {
                Player player = (Player)livingEntity2;
                yield new PlayerSleepingTicker(player);
            }
            case 2 -> {
                Bat bat = (Bat)livingEntity2;
                yield new BatSleepingTicker(bat);
            }
            case 3 -> {
                Cat cat = (Cat)livingEntity2;
                yield new CatSleepingTicker(cat);
            }
            case 4 -> {
                Fox fox = (Fox)livingEntity2;
                yield new FoxSleepingTicker(fox);
            }
            default -> new SleepingTicker(entity);
        };
    }

    private static boolean isHumanoid(Entity entity, boolean includePiglins) {
        return entity instanceof Player || ModEntityTickers.isNPC(entity, includePiglins) || entity instanceof Witch;
    }

    private static boolean isNPC(Entity entity, boolean includePiglins) {
        return entity instanceof AbstractVillager || entity instanceof AbstractIllager || includePiglins && entity instanceof AbstractPiglin;
    }
}

