/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.ParticleAnimation;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;

public class BaseAnimatedParticle
extends TextureSheetParticle {
    private final ParticleAnimation animation;

    public BaseAnimatedParticle(ClientLevel level, double x, double y, double z, ParticleAnimation animation) {
        super(level, x, y, z);
        this.animation = animation;
        this.lifetime = animation.getAnimationLifetime();
        this.updateSprite();
    }

    protected BaseAnimatedParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ParticleAnimation animation) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.animation = animation;
        this.lifetime = animation.getAnimationLifetime();
        this.updateSprite();
    }

    public void tick() {
        super.tick();
        if (!this.removed) {
            this.animation.tick();
            this.updateSprite();
        }
    }

    private void updateSprite() {
        if (!this.removed) {
            this.setSprite(this.animation.getSpriteForFrame());
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }
}

