/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSpriteSets;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.SplashParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SplashParticle
extends FlatPlaneParticle {
    private final boolean translucent;
    private final boolean glowing;
    private final TagKey<Fluid> fluidTag;
    private final SpriteSet mainSprites;
    @Nullable
    private final SpriteSet overlaySprites;
    private final SpriteSet bottomSprites;
    private final boolean hasRipple;
    private final boolean hasOverlay;
    private final BlockPos.MutableBlockPos pos;
    private float xScale;
    private final float yScale;
    private TextureAtlasSprite overlaySprite;
    private TextureAtlasSprite bottomSprite;
    private boolean isRipplePhase = false;
    private float overlayRCol = 1.0f;
    private float overlayGCol = 1.0f;
    private float overlayBCol = 1.0f;

    protected SplashParticle(ClientLevel level, double x, double y, double z, boolean translucent, boolean glowing, TagKey<Fluid> fluidTag, SpriteSet mainSprites, @Nullable SpriteSet overlaySprites, SpriteSet bottomSprites, SplashParticleOptions options) {
        super(level, x, y, z);
        this.translucent = translucent;
        this.glowing = glowing;
        this.fluidTag = fluidTag;
        this.mainSprites = mainSprites;
        this.overlaySprites = overlaySprites;
        this.bottomSprites = bottomSprites;
        this.pos = BlockPos.containing((double)x, (double)y, (double)z).mutable();
        this.hasOverlay = overlaySprites != null && ((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue() > 0.0f;
        this.lifetime = 15;
        this.hasRipple = options.hasRipple();
        this.xScale = options.xScale() / 2.0f;
        this.yScale = options.yScale() / 2.0f;
        this.quadSize = this.xScale;
        this.setSize(this.xScale, this.yScale);
        this.setSpriteFromAge();
        this.setBottomSpriteFromAge();
    }

    public ParticleRenderType getRenderType() {
        if (this.translucent) {
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    protected int getLightColor(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.getLightColor(partialTick);
    }

    public void tick() {
        this.pos.set(this.x, this.y, this.z);
        if (!this.level.getFluidState((BlockPos)this.pos).is(this.fluidTag) && !Util.getCauldronFluid(this.level.getBlockState((BlockPos)this.pos)).is(this.fluidTag)) {
            this.remove();
            return;
        }
        if (this.age++ >= this.lifetime) {
            if (!this.hasRipple || this.isRipplePhase) {
                this.remove();
                return;
            }
            this.isRipplePhase = true;
            this.lifetime = 20;
            this.age = 0;
        }
        this.xScale += 0.005f;
        if (this.isRipplePhase) {
            this.setBottomSpriteFromAge();
            return;
        }
        this.setSpriteFromAge();
    }

    private void setSpriteFromAge() {
        this.sprite = this.mainSprites.get(this.age, this.lifetime);
        if (this.hasOverlay) {
            this.overlaySprite = this.overlaySprites.get(this.age, this.lifetime);
        }
    }

    private void setBottomSpriteFromAge() {
        this.bottomSprite = this.bottomSprites.get(this.age, this.lifetime);
    }

    @Override
    protected void renderQuad(VertexConsumer consumer, Camera camera, float partialTicks, Quaternionf rotation) {
        Vec3 cameraPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z());
        float overlayAlpha = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue();
        if (this.hasRipple) {
            this.renderQuad(consumer, new Quaternionf().rotateX(1.5707964f), partialTicks, x, y, z, false, this.bottomSprite.getU0(), this.bottomSprite.getV0(), this.bottomSprite.getU1(), this.bottomSprite.getV1(), this.xScale, this.xScale, this.overlayRCol, this.overlayGCol, this.overlayBCol, overlayAlpha);
        }
        if (!this.isRipplePhase) {
            this.renderBox(consumer, partialTicks, x, y, z, this.getU0(), this.getV0(), this.getU1(), this.getV1(), this.rCol, this.gCol, this.bCol, this.alpha);
            if (this.hasOverlay) {
                this.renderBox(consumer, partialTicks, x, y, z, this.overlaySprite.getU0(), this.overlaySprite.getV0(), this.overlaySprite.getU1(), this.overlaySprite.getV1(), this.overlayRCol, this.overlayGCol, this.overlayBCol, overlayAlpha);
            }
        }
    }

    private void renderBox(VertexConsumer consumer, float partialTicks, float x, float y, float z, float u0, float v0, float u1, float v1, float red, float green, float blue, float alpha) {
        this.renderDoubleQuads(consumer, new Quaternionf(), partialTicks, x, y + this.yScale, z + this.xScale, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
        this.renderDoubleQuads(consumer, new Quaternionf().rotateY(1.5707964f), partialTicks, x - this.xScale, y + this.yScale, z, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
        this.renderDoubleQuads(consumer, new Quaternionf().rotateY((float)Math.PI), partialTicks, x, y + this.yScale, z - this.xScale, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
        this.renderDoubleQuads(consumer, new Quaternionf().rotateY(-1.5707964f), partialTicks, x + this.xScale, y + this.yScale, z, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
    }

    protected void renderDoubleQuads(VertexConsumer consumer, Quaternionf rotation, float partialTicks, float x, float y, float z, float u0, float v0, float u1, float v1, float quadWidthSize, float quadHeightSize, float red, float green, float blue, float alpha) {
        this.renderQuad(consumer, rotation, partialTicks, x, y, z, false, u0, v0, u1, v1, quadWidthSize, quadHeightSize, red, green, blue, alpha);
        this.renderQuad(consumer, rotation, partialTicks, x, y, z, true, u0, v0, u1, v1, quadWidthSize, quadHeightSize, red, green, blue, alpha);
    }

    protected void renderQuad(VertexConsumer consumer, Quaternionf rotation, float partialTicks, float x, float y, float z, boolean renderInverted, float u0, float v0, float u1, float v1, float quadWidthSize, float quadHeightSize, float red, float green, float blue, float alpha) {
        int packedLight = this.getLightColor(partialTicks);
        int i = renderInverted ? 1 : -1;
        int i2 = renderInverted ? -1 : 1;
        this.renderVertex(consumer, rotation, x, y, z, i, -1.0f, quadWidthSize, quadHeightSize, u1, v1, packedLight, red, green, blue, alpha);
        this.renderVertex(consumer, rotation, x, y, z, i, 1.0f, quadWidthSize, quadHeightSize, u1, v0, packedLight, red, green, blue, alpha);
        this.renderVertex(consumer, rotation, x, y, z, i2, 1.0f, quadWidthSize, quadHeightSize, u0, v0, packedLight, red, green, blue, alpha);
        this.renderVertex(consumer, rotation, x, y, z, i2, -1.0f, quadWidthSize, quadHeightSize, u0, v1, packedLight, red, green, blue, alpha);
    }

    protected void renderVertex(VertexConsumer buffer, Quaternionf rotation, float x, float y, float z, float xOffset, float yOffset, float quadWidthSize, float quadHeightSize, float u, float v, int packedLight, float red, float green, float blue, float alpha) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)rotation).mul(quadWidthSize, quadHeightSize, quadWidthSize).add(x, y, z);
        buffer.addVertex(vector3f.x(), vector3f.y(), vector3f.z()).setUv(u, v).setColor(red, green, blue, alpha).setLight(packedLight);
    }

    public record LavaProvider(SpriteSet sprites) implements ParticleProvider<SplashParticleOptions>
    {
        public Particle createParticle(SplashParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SplashParticle(level, x, y, z, false, true, (TagKey<Fluid>)FluidTags.LAVA, this.sprites, null, (SpriteSet)ModSpriteSets.LAVA_SPLASH_BOTTOM, options);
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SplashParticleOptions>
    {
        public Particle createParticle(SplashParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SplashParticle particle = new SplashParticle(level, x, y, z, true, false, (TagKey<Fluid>)FluidTags.WATER, this.sprites, (SpriteSet)ModSpriteSets.WATER_SPLASH_OVERLAY, (SpriteSet)ModSpriteSets.WATER_SPLASH_BOTTOM, options);
            int waterColor = ((Biome)level.getBiome(BlockPos.containing((double)x, (double)y, (double)z)).value()).getWaterColor();
            float colorIntensity = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue();
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            if (colorIntensity > 0.0f) {
                float whiteIntensity = 1.0f - colorIntensity;
                particle.overlayRCol = whiteIntensity + colorIntensity * red;
                particle.overlayGCol = whiteIntensity + colorIntensity * green;
                particle.overlayBCol = whiteIntensity + colorIntensity * blue;
            }
            particle.setColor(red, green, blue);
            return particle;
        }
    }
}

