/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.ParameterUtils;
import terrablender.api.Region;

public class VanillaParameterOverlayBuilder {
    private Map<Climate.ParameterPoint, ResourceKey<Biome>> mappings = Maps.newHashMap();

    public void add(Climate.ParameterPoint point, ResourceKey<Biome> biome) {
        this.mappings.put(point, biome);
    }

    public List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> build() {
        HashSet standalonePoints = Sets.newHashSet(this.mappings.keySet());
        HashMultimap adjacentPoints = HashMultimap.create();
        this.permuteMappings((arg_0, arg_1) -> VanillaParameterOverlayBuilder.lambda$build$0((SetMultimap)adjacentPoints, standalonePoints, arg_0, arg_1));
        ImmutableList.Builder outBuilder = ImmutableList.builder();
        outBuilder.addAll(this.mappings.entrySet().stream().map(entry -> Pair.of((Object)((Climate.ParameterPoint)entry.getKey()), (Object)((ResourceKey)entry.getValue()))).toList());
        if (!standalonePoints.isEmpty()) {
            outBuilder.addAll(standalonePoints.stream().flatMap(point -> VanillaParameterOverlayBuilder.inversePoints(List.of(point)).stream().map(inversePoint -> Pair.of((Object)inversePoint, Region.DEFERRED_PLACEHOLDER))).toList());
        }
        for (Adjacency adjacency : adjacentPoints.keySet()) {
            Set values = adjacentPoints.get((Object)adjacency);
            if (values.isEmpty()) continue;
            outBuilder.addAll(VanillaParameterOverlayBuilder.inversePoints(List.copyOf(values)).stream().map(point -> Pair.of((Object)point, Region.DEFERRED_PLACEHOLDER)).toList());
        }
        return outBuilder.build();
    }

    private void permuteMappings(BiConsumer<Climate.ParameterPoint, Climate.ParameterPoint> consumer) {
        List entries = this.mappings.entrySet().stream().toList();
        if (entries.size() == 0) {
            throw new RuntimeException("Need at least one entry to permute!");
        }
        if (entries.size() == 1) {
            Climate.ParameterPoint point = (Climate.ParameterPoint)((Map.Entry)entries.get(0)).getKey();
            consumer.accept(point, point);
        } else {
            for (int i = 0; i < entries.size(); ++i) {
                Climate.ParameterPoint pointA = (Climate.ParameterPoint)((Map.Entry)entries.get(i)).getKey();
                for (int j = i; j < entries.size(); ++j) {
                    consumer.accept(pointA, (Climate.ParameterPoint)((Map.Entry)entries.get(j)).getKey());
                }
            }
        }
    }

    private static List<Climate.ParameterPoint> inversePoints(List<Climate.ParameterPoint> values) {
        ArrayList temperatures = Lists.newArrayList();
        ArrayList humidities = Lists.newArrayList();
        ArrayList continentalnesses = Lists.newArrayList();
        ArrayList erosions = Lists.newArrayList();
        ArrayList depths = Lists.newArrayList();
        ArrayList weirdnesses = Lists.newArrayList();
        for (Climate.ParameterPoint point : values) {
            temperatures.add(point.temperature());
            humidities.add(point.humidity());
            continentalnesses.add(point.continentalness());
            erosions.add(point.erosion());
            depths.add(point.depth());
            weirdnesses.add(point.weirdness());
        }
        temperatures.sort(Comparator.comparing(Climate.Parameter::min));
        humidities.sort(Comparator.comparing(Climate.Parameter::min));
        continentalnesses.sort(Comparator.comparing(Climate.Parameter::min));
        erosions.sort(Comparator.comparing(Climate.Parameter::min));
        depths.sort(Comparator.comparing(Climate.Parameter::min));
        weirdnesses.sort(Comparator.comparing(Climate.Parameter::min));
        return new ParameterUtils.ParameterPointListBuilder().temperature((Climate.Parameter[])VanillaParameterOverlayBuilder.inverseParameters(temperatures).toArray(Climate.Parameter[]::new)).humidity((Climate.Parameter[])VanillaParameterOverlayBuilder.inverseParameters(humidities).toArray(Climate.Parameter[]::new)).continentalness((Climate.Parameter[])VanillaParameterOverlayBuilder.inverseParameters(continentalnesses).toArray(Climate.Parameter[]::new)).erosion((Climate.Parameter[])VanillaParameterOverlayBuilder.inverseParameters(erosions).toArray(Climate.Parameter[]::new)).depth((Climate.Parameter[])VanillaParameterOverlayBuilder.inverseParameters(depths).toArray(Climate.Parameter[]::new)).weirdness((Climate.Parameter[])VanillaParameterOverlayBuilder.inverseParameters(weirdnesses).toArray(Climate.Parameter[]::new)).build();
    }

    private static List<Climate.Parameter> inverseParameters(List<Climate.Parameter> values) {
        if (values.isEmpty()) {
            return List.of(Climate.Parameter.span((float)-1.0f, (float)1.0f));
        }
        ArrayList out = Lists.newArrayList();
        float prevMax = -1.0f;
        for (Climate.Parameter value : values) {
            float min = Climate.unquantizeCoord((long)value.min());
            float max = Climate.unquantizeCoord((long)value.max());
            if (min - prevMax > 0.0f) {
                out.add(Climate.Parameter.span((float)prevMax, (float)min));
            }
            prevMax = max;
        }
        if (prevMax < 1.0f) {
            out.add(Climate.Parameter.span((float)prevMax, (float)1.0f));
        }
        return out;
    }

    private static /* synthetic */ void lambda$build$0(SetMultimap adjacentPoints, Set standalonePoints, Climate.ParameterPoint a, Climate.ParameterPoint b) {
        if (a.equals((Object)b)) {
            return;
        }
        for (Adjacency adjacency : Adjacency.values()) {
            if (!adjacency.isAdjacent(a, b)) continue;
            adjacentPoints.put((Object)adjacency, (Object)a);
            adjacentPoints.put((Object)adjacency, (Object)b);
            standalonePoints.remove(a);
            standalonePoints.remove(b);
        }
    }

    private static enum Adjacency {
        TEMPERATURE(Climate.ParameterPoint::temperature),
        HUMIDITY(Climate.ParameterPoint::humidity),
        CONTINENTALNESS(Climate.ParameterPoint::continentalness),
        EROSION(Climate.ParameterPoint::erosion),
        DEPTH(Climate.ParameterPoint::depth),
        WEIRDNESS(Climate.ParameterPoint::weirdness);

        Function<Climate.ParameterPoint, Climate.Parameter> getter;

        private Adjacency(Function<Climate.ParameterPoint, Climate.Parameter> getter) {
            this.getter = getter;
        }

        public Climate.Parameter getParameter(Climate.ParameterPoint point) {
            return this.getter.apply(point);
        }

        public boolean isAdjacent(Climate.ParameterPoint a, Climate.ParameterPoint b) {
            for (Adjacency adjacency : Adjacency.values()) {
                Climate.Parameter paramA = adjacency.getParameter(a);
                Climate.Parameter paramB = adjacency.getParameter(b);
                if (adjacency == this && paramA.equals((Object)paramB)) {
                    return false;
                }
                if (adjacency == this || paramA.equals((Object)paramB)) continue;
                return false;
            }
            return true;
        }
    }
}

